<?php
/**
 * NOTICE OF LICENSE.
 *
 * This source file is subject to a commercial license from Agence Malttt SAS
 * Use, copy, modification or distribution of this source file without written
 * license agreement from the Agence Malttt SAS is strictly forbidden.
 * INFORMATION SUR LA LICENCE D'UTILISATION
 * L'utilisation de ce fichier source est soumise a une licence commerciale
 * concedee par la societe Agence Malttt SAS
 * Toute utilisation, reproduction, modification ou distribution du present
 * fichier source sans contrat de licence ecrit de la part d'Agence Malttt SAS est expressement interdite.
 *
 * @author    Matthieu Deroubaix
 * @copyright Copyright (c) 2015-2016 Agence Malttt SAS - 90 Rue faubourg saint martin - 75010 Paris
 * @license   Commercial license
 * Support by mail  :  support@agence-malttt.fr
 * Phone : +33.972535133
 */

if (!defined('_PS_VERSION_')) {
    exit;
}

class SimpleSitemap extends Module
{
    public function __construct()
    {
        $this->name = 'simplesitemap';
        $this->tab = 'seo';
        $this->bootstrap = true;
        $this->version = '1.3.2';
        $this->author = 'AgenceMalttt';
        $this->ps_versions_compliancy = array('min' => '1.5', 'max' => _PS_VERSION_);
        $this->need_instance = 0;

        $this->tabs_form = array(
            'general' => $this->l('General Settings'),
            'freq' => $this->l('Frequencies'),
            'images' => $this->l('Images'),
        );

        $img_cats = ImageType::getImagesTypes('categories');
        $img_prods = ImageType::getImagesTypes('products');

        $this->fields_form = array(
            array(
                'name' => 'SIMPSMP_CACHETIME',
                'type' => 'text',
                'desc' => $this->l('Cache time (in minutes)'),
                'label' => $this->l('Cache time (in minutes)'),
                'default' => '60',
                'validate' => 'isInt',
                'tab' => 'general',
            ),
            array(
                'name' => 'SIMPSMP_LANG_MODE',
                'type' => 'radio',
                'desc' => $this->l('Sitemap by each language per shop (exemple.com/en/sitemap_index.xml) or just by shop (exemple.com/sitemap_index.xml, recommended by Google)'),
                'label' => $this->l('Separated sitemaps per language'),
                'default' => '0',
                'tab' => 'general',
                'values' => array(
                    array(
                        'id' => 'type_l_0',
                        'value' => 0,
                        'label' => $this->l('Per shop'),
                    ),
                    array(
                        'id' => 'type_l_1',
                        'value' => 1,
                        'label' => $this->l('Per lang & per shop'),
                    ),
                ),
            ),
            array(
                'name' => 'SIMPSMP_EXC_LANG',
                'type' => 'text',
                'desc' => $this->l('Excluded languages from sitemap, iso code separated by comma. Ex : en,fr,es'),
                'label' => $this->l('Excluded languages'),
                'tab' => 'general',
            ),
            array(
                'name' => 'SIMPSMP_CMS',
                'type' => 'radio',
                'desc' => $this->l('Include CMS and Rewrited pages'),
                'label' => $this->l('Include CMS & Rewrited pages'),
                'default' => '1',
                'tab' => 'general',
                'values' => array(
                    array(
                        'id' => 'type_cms_0',
                        'value' => 0,
                        'label' => $this->l('No'),
                    ),
                    array(
                        'id' => 'type_cms_1',
                        'value' => 1,
                        'label' => $this->l('Yes'),
                    ),
                ),
            ),
            array(
                'name' => 'SIMPSMP_PRODUCTS',
                'type' => 'radio',
                'desc' => $this->l('Include products in sitemap'),
                'label' => $this->l('Include products'),
                'default' => '1',
                'tab' => 'general',
                'values' => array(
                    array(
                        'id' => 'type_p_0',
                        'value' => 0,
                        'label' => $this->l('No'),
                    ),
                    array(
                        'id' => 'type_p_1',
                        'value' => 1,
                        'label' => $this->l('Yes'),
                    ),
                ),
            ),
            array(
                'name' => 'SIMPSMP_CATEGORIES',
                'type' => 'radio',
                'desc' => $this->l('Include categories'),
                'label' => $this->l('Include categories'),
                'default' => '1',
                'tab' => 'general',
                'values' => array(
                    array(
                        'id' => 'type_c_0',
                        'value' => 0,
                        'label' => $this->l('No'),
                    ),
                    array(
                        'id' => 'type_c_1',
                        'value' => 1,
                        'label' => $this->l('Yes'),
                    ),
                ),
            ),
            array(
                'name' => 'SIMPSMP_BLOG',
                'type' => 'radio',
                'desc' => $this->l('Available for :').' Prestablog, BlogPRO, SimpleBlog, AdvancedBlog, AmazzingBlog, StBlog and SmartBlog.',
                'label' => $this->l('Include Blog (Module must be installed)'),
                'default' => '0',
                'tab' => 'general',
                'values' => array(
                    array(
                        'id' => 'type_b_0',
                        'value' => 0,
                        'label' => $this->l('No'),
                    ),
                    array(
                        'id' => 'type_b_1',
                        'value' => 1,
                        'label' => $this->l('Yes'),
                    ),
                ),
            ),
            array(
                'name' => 'SIMPSMP_MANUFACTURERS',
                'type' => 'radio',
                'desc' => $this->l('Include manufacturers pages'),
                'label' => $this->l('Include manufacturers pages'),
                'default' => '1',
                'tab' => 'general',
                'values' => array(
                    array(
                        'id' => 'type_m_0',
                        'value' => 0,
                        'label' => $this->l('No'),
                    ),
                    array(
                        'id' => 'type_m_1',
                        'value' => 1,
                        'label' => $this->l('Yes'),
                    ),
                ),
            ),
            array(
                'name' => 'SIMPSMP_SUPPLIERS',
                'type' => 'radio',
                'desc' => $this->l('Include suppliers pages'),
                'label' => $this->l('Include suppliers pages'),
                'default' => '0',
                'tab' => 'general',
                'values' => array(
                    array(
                        'id' => 'type_sp_0',
                        'value' => 0,
                        'label' => $this->l('No'),
                    ),
                    array(
                        'id' => 'type_sp_1',
                        'value' => 1,
                        'label' => $this->l('Yes'),
                    ),
                ),
            ),
            array(
                'name' => 'SIMPSMP_OTHERS',
                'type' => 'radio',
                'desc' => $this->l('Include other specified pages below'),
                'label' => $this->l('Include other specified pages below'),
                'default' => '1',
                'tab' => 'general',
                'values' => array(
                    array(
                        'id' => 'type_o_0',
                        'value' => 0,
                        'label' => $this->l('No'),
                    ),
                    array(
                        'id' => 'type_o_1',
                        'value' => 1,
                        'label' => $this->l('Yes'),
                    ),
                ),
            ),
            array(
                'name' => 'SIMPSMP_ROB',
                'type' => 'textarea',
                'label' => $this->l('Robots.txt appened text'),
                'desc' => $this->l('You can add text to your robots.txt here'),
                'autoload_rte' => true,
                'html' => true,
                'tab' => 'general',
            ),
            array(
                'name' => 'SIMPSMP_REWRITE_URL',
                'type' => 'text',
                'default' => 'sitemap',
                'desc' => $this->l('Rewrite url (natively "sitemap") for sitemap'),
                'label' => $this->l('Sitemap base rewrite url'),
                'tab' => 'general',
            ),
            array(
                'name' => 'SIMPSMP_FREQ_SUPPLIERS',
                'type' => 'select',
                'desc' => $this->l('Frequency updates indicated for suppliers'),
                'label' => $this->l('Frequency suppliers'),
                'default' => 'weekly',
                'options' => array(
                    'query' => $this->getFrequencies(),
                    'id' => 'name',
                    'name' => 'name',
                ),
                'tab' => 'freq',
            ),
            array(
                'name' => 'SIMPSMP_FREQ_OTHERS',
                'type' => 'select',
                'desc' => $this->l('Frequency updates indicated for other links'),
                'label' => $this->l('Frequency other links'),
                'default' => 'weekly',
                'options' => array(
                    'query' => $this->getFrequencies(),
                    'id' => 'name',
                    'name' => 'name',
                ),
                'tab' => 'freq',
            ),
            array(
                'name' => 'SIMPSMP_FREQ_CMS',
                'type' => 'select',
                'desc' => $this->l('Frequency updates indicated for cms'),
                'label' => $this->l('Frequency for cms'),
                'default' => 'weekly',
                'options' => array(
                    'query' => $this->getFrequencies(),
                    'id' => 'name',
                    'name' => 'name',
                ),
                'tab' => 'freq',
            ),
            array(
                'name' => 'SIMPSMP_FREQ_BLOG',
                'type' => 'select',
                'desc' => $this->l('Frequency updates indicated for blog'),
                'label' => $this->l('Frequency blog'),
                'default' => 'weekly',
                'options' => array(
                    'query' => $this->getFrequencies(),
                    'id' => 'name',
                    'name' => 'name',
                ),
                'tab' => 'freq',
            ),
            array(
                'name' => 'SIMPSMP_FREQ_PRODUCTS',
                'type' => 'select',
                'desc' => $this->l('Frequency updates indicated for products'),
                'label' => $this->l('Frequency products'),
                'default' => 'weekly',
                'options' => array(
                    'query' => $this->getFrequencies(),
                    'id' => 'name',
                    'name' => 'name',
                ),
                'tab' => 'freq',
            ),
            array(
                'name' => 'SIMPSMP_FREQ_CATEGORIES',
                'type' => 'select',
                'desc' => $this->l('Frequency updates indicated for categories'),
                'label' => $this->l('Frequency categories'),
                'default' => 'weekly',
                'options' => array(
                    'query' => $this->getFrequencies(),
                    'id' => 'name',
                    'name' => 'name',
                ),
                'tab' => 'freq',
            ),
            array(
                'name' => 'SIMPSMP_FREQ_MANUFACTURERS',
                'type' => 'select',
                'desc' => $this->l('Frequency updates indicated for manufacturers'),
                'label' => $this->l('Frequency manufacturers'),
                'default' => 'weekly',
                'options' => array(
                    'query' => $this->getFrequencies(),
                    'id' => 'name',
                    'name' => 'name',
                ),
                'tab' => 'freq',
            ),
            array(
                'name' => 'SIMPSMP_C_IMG',
                'type' => 'select',
                'desc' => $this->l('Image type for categories in sitemap'),
                'label' => $this->l('Image type for categories'),
                'default' => (isset($img_cats[0]['name']) ? $img_cats[0]['name'] : ''),
                'options' => array(
                    'query' => $img_cats,
                    'id' => 'name',
                    'name' => 'name',
                ),
                'tab' => 'images',
            ),
            array(
                'name' => 'SIMPSMP_P_IMG',
                'type' => 'select',
                'desc' => $this->l('Image type for products in sitemap'),
                'label' => $this->l('Image type for products'),
                'default' => (isset($img_prods[0]['name']) ? $img_prods[0]['name'] : ''),
                'options' => array(
                    'query' => $img_prods,
                    'id' => 'name',
                    'name' => 'name',
                ),
                'tab' => 'images',
            ),
        );

        $this->secure_key = Tools::encrypt($this->name);

        $this->module_key = 'a8e5536f4c44c49bb6da26d8b1522f84';
        $this->author_address = '0xc1dcC59643a63D65e05F1F9d8e985dbb9CDe344f';

        $this->displayName = $this->l('Simple Sitemap');
        $this->description = $this->l('Sitemap for multistore in all languages with blog features.');
        $this->cache_folder = _PS_CACHE_DIR_."/".$this->name."/";
        $this->cache_robots = $this->cache_folder.'robots.txt';

        $this->hooks = array('moduleRoutes');

        parent::__construct();
    }

    private function getFrequencies()
    {
        if (!isset($this->freq_a)) {
            $a = array(
                'always',
                'hourly',
                'daily',
                'weekly',
                'monthly',
                'yearly',
                'never',
            );

            $r = array();

            foreach ($a as $v) {
                $r[] = array('name' => $v);
            }

            $this->freq_a = $r;
        }

        return $this->freq_a;
    }

    public function install()
    {
        if (is_writable(_PS_CACHE_DIR_)) {
            if (!file_exists($this->cache_folder)) {
                try {
                    mkdir($this->cache_folder);
                } catch (Exception $e) {
                    error_log($e->getMessage());
                }
            }

            if (!is_writable($this->cache_folder)) {
                try {
                    chmod($this->cache_folder, 0777);
                } catch (Exception $e) {
                    error_log($e->getMessage());
                }
            }
        }

        if ($this->fields_form && count($this->fields_form) > 0) {
            foreach ($this->fields_form as $value) {
                if (isset($value['default'])) {
                    Configuration::updateValue($value['name'], $value['default']);
                }
            }
        }

        if (!parent::install()) {
            return false;
        } else {
            if (isset($this->hooks) && !empty($this->hooks)) {
                foreach ($this->hooks as $v) {
                    if (!$this->registerHook($v)) {
                        return false;
                    }
                }
            }
        }

        $sql_install = dirname(__FILE__).'/sql/install.php';

        if (file_exists($sql_install)) {
            $sql = array();

            require_once $sql_install;

            if (!empty($sql)) {
                foreach ($sql as $s) {
                    if (!Db::getInstance()->execute($s)) {
                        return false;
                    }
                }
            }
        }

        $tab = new Tab();
        $tab->class_name = 'AdminSimpleSitemapRemove';
        $tab->id_parent = 0;
        $tab->active = false;
        $tab->module = $this->name;

        $tab2 = new Tab();
        $tab2->class_name = 'AdminSimpleSitemapOther';
        $tab2->id_parent = 0;
        $tab2->active = false;
        $tab2->module = $this->name;

        foreach (Language::getLanguages(true) as $lang) {
            $tab->name[$lang['id_lang']] = $this->l('Sitemap URL Remover');
            $tab2->name[$lang['id_lang']] = $this->l('Sitemap URL Adder');
        }

        $tab->add();
        $tab2->add();

        if (Module::isInstalled('cronjobs') && Module::isEnabled('cronjobs') && class_exists('CronJobs')) {
            $link = new Link();

            $description = 'Sitemap Ping';

            $cron_url = $link->getModuleLink($this->name, 'sitemap', array('rewrite' => 'index', 'cron' => $this->secure_key));

            $execution = array();
            $execution['hour'] = 2;
            $execution['day'] = -1;
            $execution['month'] = -1;
            $execution['day_of_week'] = -1;

            require_once _PS_MODULE_DIR_.'cronjobs/cronjobs.php';

            $cronjob = new CronJobs();

            // Old version of this function is static
            $result = $cronjob->addOneShotTask(
                $cron_url,
                $description,
                $execution
            );

            if ($result != false) {

                // Not a one shot, better using existing methods
                Db::getInstance()->execute('UPDATE '._DB_PREFIX_.'cronjobs
                SET `one_shot` = 0 WHERE `task` = \''.urlencode($cron_url).'\' ');
            }
        }

        // Setup new robots with sitemap rule included
        $this->prepareRobots();

        return true;
    }

    public function uninstall()
    {

          // Tabs
        $idTabs = array();
        $idTabs[] = Tab::getIdFromClassName('AdminSimpleSitemapOther');
        $idTabs[] = Tab::getIdFromClassName('AdminSimpleSitemapRemove');

        foreach ($idTabs as $idTab) {
            if ($idTab) {
                $tab = new Tab($idTab);
                $tab->delete();
            }
        }

        if (Module::isInstalled('cronjobs') && Module::isEnabled('cronjobs')) {
            $link = new Link();
            $cron_url = $link->getModuleLink($this->name, 'sitemap', array('rewrite' => 'index', 'cron' => $this->secure_key));
            Db::getInstance()->execute('DELETE FROM '._DB_PREFIX_.'cronjobs WHERE `task` = \''.urlencode($cron_url).'\' ');
        }

        return parent::uninstall();
    }

    public function getContent()
    {
        if (!$this->isRegisteredInHook('moduleRoutes')) {
            $this->registerHook('moduleRoutes');
        }

        $this->postProcess();

        $render = $this->getPreform().$this->renderForm().$this->getPostform();

        return $render;
    }

    public function getPostform()
    {
        return $this->display(__FILE__, 'postform.tpl');
    }

    public function getPreform()
    {
        $link = new Link();

        $cron_url = $link->getModuleLink($this->name, 'sitemap', array('rewrite' => 'index', 'cron' => $this->secure_key));

        $sitemap_shop_urls = array();

        $all_langs = Configuration::get('SIMPSMP_LANG_MODE');

        foreach (ShopUrl::getShopUrls() as $shop_url) {
            $langs = $this->getSitemapLanguages($shop_url->id, $all_langs);
            foreach ($langs as $lang) {
                $res = $this->getSitemapLink('index', $lang['id_lang'], $shop_url->id_shop);
                $sitemap_shop_urls[$shop_url->id."-".(int) $lang['id_lang']] = $res;
            }
            $sitemap_shop_urls = array_unique($sitemap_shop_urls);
        }

        $cronjobs_installed = Module::isInstalled('cronjobs') && Module::isEnabled('cronjobs');

        $this->context->smarty->assign(
            array(
                'displayName' => $this->displayName,
                'description' => $this->description,
                'link' => $link,
                'logo_img' => __PS_BASE_URI__.'modules/'.$this->name.'/logo.png',
                'cron_url' => $cron_url,
                'sitemap_shop_urls' => $sitemap_shop_urls,
                'cronjobs_installed' => $cronjobs_installed,
            )
        );

        return $this->display(__FILE__, 'preform.tpl');
    }

    public function renderForm()
    {
        if ($this->fields_form == null) {
            return false;
        }

        $fields = $this->fields_form;

        $fields_form = array(
            'tinymce' => true,
            'form' => array(
                'legend' => array(
                    'title' => $this->l('Configuration for ').$this->displayName,
                    'icon' => 'icon-cogs',
                ),
                'input' => $fields,
                'submit' => array(
                    'title' => $this->l('Save'),
                ),
            ),
        );

        if (isset($this->tabs_form)) {
            $fields_form['form']['tabs'] = $this->tabs_form;
        }

        $helper = new HelperForm();
        $helper->show_toolbar = (isset($this->show_toolbar) ? $this->show_toolbar : false);

        $helper->table = $this->table;
        $helper->module = $this;
        $lang = new Language((int) Configuration::get('PS_LANG_DEFAULT'));

        $helper->submit_action = 'submit'.Tools::ucfirst($this->name);
        $helper->default_form_language = $lang->id;
        $helper->allow_employee_form_lang = Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG') ? Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG') : 0;
        $helper->identifier = $this->identifier;
        $helper->currentIndex = $this->context->link->getAdminLink('AdminModules', false).'&configure='.$this->name.'&tab_module='.$this->tab.'&module_name='.$this->name;
        $helper->token = Tools::getAdminTokenLite('AdminModules');
        $helper->tpl_vars = array(
            'fields_value' => $this->getConfigFieldValues(),
            'languages' => $this->context->controller->getLanguages(),
            'id_language' => $this->context->language->id,
        );

        return $helper->generateForm(array($fields_form));
    }

    public function getConfigFieldValues()
    {
        if ($this->fields_form == null) {
            return false;
        }

        $array = $this->fields_form;
        $languages = Language::getLanguages(false);

        $field_values = array();

        foreach ($array as $value) {
            if (isset($value['lang']) && $value['lang'] == true) {
                foreach ($languages as $lang) {
                    $field_values[$value['name']][$lang['id_lang']] = Configuration::get($value['name'], $lang['id_lang']);
                }
            } else {
                $field_values[$value['name']] = Configuration::get($value['name']);
            }
        }

        return $field_values;
    }

    public static function getRootCategory()
    {
        $root_category = Category::getRootCategory();

        $root_category = array('id_category' => $root_category->id, 'name' => $root_category->name);

        return $root_category;
    }

    public function postProcess()
    {
        if (!isset($this->fields_form)) {
            return parent::postProcess();
        }

        // Just an update
        $this->prepareRobots();

        $values = $this->fields_form;

        if (!($languages = Language::getLanguages(true))) {
            return false;
        }

        if (Tools::isSubmit('submit'.Tools::ucfirst($this->name))) {
            foreach ($values as $value) {
                if (isset($value['lang']) && $value['lang'] == true) {
                    switch ($value['type']) {
                        case 'text':
                        case 'textarea':
                        case 'select':

                                $text = array();

                            foreach ($languages as $lang) {
                                $text[$lang['id_lang']] = Tools::getValue($value['name'].'_'.$lang['id_lang']);
                            }

                            if (isset($value['validate']) && !empty($value['validate'])) {
                                foreach ($text as $k => $v) {
                                    if ($value['validate'] == 'isInt') {
                                        $text[$k] = (int) $text[$k];
                                    } elseif ($value['validate'] == 'isFloat') {
                                        $text[$k] = (float) $text[$k];
                                    } elseif ($value['validate'] == 'isBool') {
                                        $text[$k] = (bool) $text[$k];
                                    }
                                }
                            }

                                Configuration::updateValue($value['name'], $text, (isset($value['html']) ? $value['html'] : false));

                            break;

                        case 'file':
                            foreach ($languages as $lang) {
                                if (isset($_FILES[$value['name'].'_'.$lang['id_lang']]) && isset($_FILES[$value['name'].'_'.$lang['id_lang']]['tmp_name']) && !empty($_FILES[$value['name'].'_'.$lang['id_lang']]['tmp_name'])) {
                                    if (ImageManager::validateUpload($_FILES[$value['name'].'_'.$lang['id_lang']], 4000000)) {
                                        return $this->displayError($this->l('Invalid image.'));
                                    } else {
                                        $ext = Tools::substr($_FILES[$value['name'].'_'.$lang['id_lang']]['name'], strrpos($_FILES[$value['name'].'_'.$lang['id_lang']]['name'], '.') + 1);
                                        $file_name = md5($_FILES[$value['name'].'_'.$lang['id_lang']]['name']).'.'.$ext;

                                        if (!move_uploaded_file($_FILES[$value['name'].'_'.$lang['id_lang']]['tmp_name'], dirname(__FILE__).'/public/img/'.$file_name)) {
                                            return $this->displayError($this->l('An error occurred while attempting to upload the file.'));
                                        } else {
                                            if (Configuration::hasContext($value['name'].'_'.$lang['id_lang'], null, Shop::getContext()) && Configuration::get($value['name'].'_'.$lang['id_lang']) != $file_name) {
                                                @unlink(dirname(__FILE__).'/public/imgs/'.Configuration::get($value['name'].'_'.$lang['id_lang']));
                                            }
                                            $text[$lang['id_lang']] = '/modules/'.$this->name.'/public/img/'.$file_name;
                                        }
                                    }
                                }
                                if (count($text) > 0) {
                                    Configuration::updateValue($value['name'], $text);
                                }
                            }
                            break;

                        case 'switch':

                                Configuration::updateValue($value['name'], Tools::getValue($value['name'].'_'.$lang['id_lang']));

                            break;

                        default:

                                Configuration::updateValue($value['name'], Tools::getValue($value['name'].'_'.$lang['id_lang']), (isset($value['html']) ? $value['html'] : false));

                            break;
                    }
                } else {
                    switch ($value['type']) {
                        case 'text':
                        case 'textarea':
                        case 'select':

                            $v = Tools::getValue($value['name']);

                            if (isset($value['validate']) && !empty($value['validate'])) {
                                if ($value['validate'] == 'isInt') {
                                    $v = (int) $v;
                                } elseif ($value['validate'] == 'isFloat') {
                                    $v = (float) $v;
                                } elseif ($value['validate'] == 'isBool') {
                                    $v = (bool) $v;
                                }
                            }

                            Configuration::updateValue($value['name'], $v, (isset($value['html']) ? $value['html'] : false));

                            break;

                        case 'file':
                            if (isset($_FILES[$value['name']]) && isset($_FILES[$value['name']]['tmp_name']) && !empty($_FILES[$value['name']]['tmp_name'])) {
                                if (ImageManager::validateUpload($_FILES[$value['name']], 4000000)) {
                                    return $this->displayError($this->l('Invalid image.'));
                                } else {
                                    $ext = Tools::substr($_FILES[$value['name']]['name'], strrpos($_FILES[$value['name']]['name'], '.') + 1);
                                    $file_name = md5($_FILES[$value['name']]['name']).'.'.$ext;
                                    if (!move_uploaded_file($_FILES[$value['name']]['tmp_name'], dirname(__FILE__).'/public/imgs/'.$file_name)) {
                                        return $this->displayError($this->l('An error occurred while attempting to upload the file.'));
                                    } else {
                                        if (Configuration::hasContext($value['name'], null, Shop::getContext()) && Configuration::get($value['name']) != $file_name) {
                                            @unlink(dirname(__FILE__).'/'.Configuration::get($value['name']));
                                        }
                                        Configuration::updateValue($value['name'], '/modules/'.$this->name.'/public/imgs/'.$file_name);
                                    }
                                }
                            }

                            break;

                        case 'switch':

                                Configuration::updateValue($value['name'], Tools::getValue($value['name']));

                            break;

                        default:

                                Configuration::updateValue($value['name'], Tools::getValue($value['name']), (isset($value['html']) ? $value['html'] : false));

                            break;

                    }
                }
            }

            // Display update confirmation, if they are here it's ok, they passed all errors
            Tools::redirectAdmin(AdminController::$currentIndex.'&configure='.$this->name.'&token='.Tools::getAdminTokenLite('AdminModules').'&conf=6');
        }
    }

    public function prepareRobots($path = null)
    {
        if (is_null($path)) {
            $path = _PS_ROOT_DIR_.'/robots.txt';
        }

        if (file_exists($path)) {
            $content = Tools::file_get_contents($path);

            if (is_writable($this->cache_folder)) {
                if (file_put_contents($this->cache_robots, $content)) {
                    @unlink($path);
                }
            }
        } else {
            $content = '';
        }

        return $content;
    }

    public function getRobotRules($path = null)
    {
        $content = $this->prepareRobots($path);
        $context = Context::getContext();

        if (file_exists($this->cache_robots)) {
            $pre_content = Tools::file_get_contents($this->cache_robots);
            if (!empty($pre_content)) {
                $content = $pre_content;
            }
        }

        if ((bool) Configuration::get('SIMPSMP_LANG_MODE') == true) {
            $id_lang = $context->language->id;
        } else {
            $id_lang = null;
        }

        $sitemap_link = $this->getSitemapLink('index', $id_lang, $context->shop->id);

        $appened = Configuration::get('SIMPSMP_ROB');

        if (!empty($appened)) {
            $appened = strip_tags($appened, '<br>');
            $breaks = array("<br />","<br>","<br/>");
            $appened = str_ireplace($breaks, "\r\n", $appened);
        }

        $render = 'Sitemap: '.$sitemap_link."\n".$content."\n".$appened;

        header('Content-Type: text/plain');

        echo $render;
    }

    public function getBaseLink($id_shop = null, $ssl = null, $relative_protocol = false)
    {
        $ssl_enable = Configuration::get('PS_SSL_ENABLED');

        if ($ssl === null) {
            $force_ssl = (Configuration::get('PS_SSL_ENABLED') && Configuration::get('PS_SSL_ENABLED_EVERYWHERE'));
            $ssl = $force_ssl;
        }

        if (Configuration::get('PS_MULTISHOP_FEATURE_ACTIVE') && $id_shop !== null) {
            $shop = new Shop($id_shop);
        } else {
            $shop = Context::getContext()->shop;
        }

        if ($relative_protocol) {
            $base = '//'.($ssl && $ssl_enable ? $shop->domain_ssl : $shop->domain);
        } else {
            $base = (($ssl && $ssl_enable) ? 'https://'.$shop->domain_ssl : 'http://'.$shop->domain);
        }

        return $base.$shop->getBaseURI();
    }

    public function hookModuleRoutes()
    {
        $route_conf = Configuration::get('SIMPSMP_REWRITE_URL');

        if (empty($route_conf)) {
            $route_conf = "sitemap";
        }

        $route = array(
            'module-'.$this->name.'-sitemap' => array(
                'controller' => 'sitemap',
                'rule' => $route_conf.'_{rewrite}.xml',
                'keywords' => array(
                    'rewrite' => array('regexp' => '[_a-zA-Z0-9-\pL]*', 'param' => 'rewrite'),
                ),
                'params' => array(
                    'fc' => 'module',
                    'module' => $this->name,
                ),
            ),
            'module-'.$this->name.'-robots' => array(
                'controller' => 'robots',
                'rule' => 'robots.txt',
                'keywords' => array(
                    'rewrite' => array('regexp' => '[_a-zA-Z0-9-\pL]*', 'param' => 'rewrite'),
                ),
                'params' => array(
                    'fc' => 'module',
                    'module' => $this->name,
                ),
            ),
        );

        return $route;
    }

    public function getSitemapLanguages($id_shop = null, $all_langs = false)
    {
        if ((bool)$all_langs == true) {
            $sql_not_in = ' ';

            $not_in_lang = Configuration::get('SIMPSMP_EXC_LANG', null, null, (int) $id_shop);

            if (!empty($not_in_lang)) {

                // Sanitize
                $exp = explode(',', trim($not_in_lang));

                $exp = array_filter($exp);

                $exp_array = array();

                foreach ($exp as $val) {
                    $exp_array[] = '"'.trim($val).'"';
                }

                $imp = implode(',', $exp_array);

                $sql_not_in .= ' AND l.iso_code NOT IN ('.$imp.') ';
            }

            $sql = 'SELECT l.id_lang FROM '._DB_PREFIX_.'lang l INNER JOIN '._DB_PREFIX_.'lang_shop sl ON (sl.id_shop = '.(int) $id_shop.' AND sl.id_lang = l.id_lang) WHERE l.active = 1 '.$sql_not_in;

            $langs = Db::getInstance()->executeS($sql);
        }

        if (!isset($langs) || empty($langs)) {

            // Workaround
            $langs[0] = array('id_lang' => null);
        }

        return $langs;
    }

    public function getSitemapLink($type = 'index', $id_lang = null, $id_shop = null)
    {
        $link = Context::getContext()->link;
        $params = array();
        $params['rewrite'] = $type;
        $params['module'] = $module = $this->name;
        $params['controller'] = $controller = 'sitemap';

        $new_link = $link->getPageLink('module-'.$module.'-'.$controller, null, $id_lang, $params, false, $id_shop);

        if (empty($id_lang)) {
            if ((bool) Configuration::get('PS_REWRITING_SETTINGS') == true && version_compare(_PS_VERSION_, '1.6.0.0') >= 0) {
                $id_lang = Context::getContext()->language->id;
                $lang_link = '/'.Language::getIsoById($id_lang).'/';
                $new_link = str_replace(array($lang_link, '?', '&', 'rewrite=', '/module/'.$this->name, '.xml'), array('/', '', '', '_', '', ''), $new_link).'.xml';
            }
        }

        return $new_link;
    }
}
