<?php
/**
 * NOTICE OF LICENSE.
 *
 * This source file is subject to a commercial license from Agence Malttt SAS
 * Use, copy, modification or distribution of this source file without written
 * license agreement from the Agence Malttt SAS is strictly forbidden.
 * INFORMATION SUR LA LICENCE D'UTILISATION
 * L'utilisation de ce fichier source est soumise a une licence commerciale
 * concedee par la societe Agence Malttt SAS
 * Toute utilisation, reproduction, modification ou distribution du present
 * fichier source sans contrat de licence ecrit de la part d'Agence Malttt SAS est expressement interdite.
 *
 * @author    Matthieu Deroubaix
 * @copyright Copyright (c) 2015-2016 Agence Malttt SAS - 90 Rue faubourg saint martin - 75010 Paris
 * @license   Commercial license
 * Support by mail  :  support@agence-malttt.fr
 * Phone : +33.972535133
 */

require_once _PS_MODULE_DIR_.'simplesitemap/simplesitemap.php';
require_once _PS_MODULE_DIR_.'simplesitemap/models/SimpleSitemapRemove.php';

class AdminSimpleSitemapRemoveController extends ModuleAdminController
{
    protected $_defaultOrderBy = 'id_simplesitemapremove';
    protected $_defaultOrderWay = 'DESC';
    protected $actions_available = array('view', 'edit', 'delete');

    public function __construct()
    {
        $this->table = 'simplesitemapremove';
        $this->className = 'SimpleSitemapRemove';

        $this->context = Context::getContext();
        $this->lang = false;
        $this->bootstrap = true;
        $this->allow_export = true;
        $this->requiredDatabase = true;
        $this->multishop_context = Shop::CONTEXT_ALL;
        $this->mod = new SimpleSitemap;

        $this->addRowAction('edit');
        $this->addRowAction('delete');

        $this->page_header_toolbar_title = $this->mod->l('Sitemap URL Remover');

        $this->fields_list = array(
            'id_simplesitemapremove' => array(
                'title' => '#',
                'align' => 'center',
                'type' => 'int',
            ),
            'url' => array(
                'title' => $this->mod->l('URL'),
                'align' => 'center',
            ),
            'date_add' => array(
                'title' => $this->mod->l('Add Date'),
                'align' => 'center',
                'type' => 'datetime',
                'width' => 5,
            ),
        );

        $this->bulk_actions = array(
            'delete' => array(
                'text' => $this->mod->l('delete selected'), 'confirm' => $this->mod->l('Delete selected entries ?'),
            ),
        );

        $this->context = Context::getContext();
        parent::__construct();
    }

    public function renderForm()
    {
        $array_submit = array(
            array(
                'type' => 'text',
                'label' => $this->mod->l('Url :'),
                'name' => 'url',
            ),
        );

        $this->fields_form = array(
            'tinymce' => false,
            'legend' => array(
                'title' => $this->mod->l('Create and edit URL to remove from sitemaps'),
            ),
            'input' => $array_submit,
            'submit' => array(
                'title' => $this->mod->l('Save'),
                'class' => 'btn btn-default',
            ),
        );

        return parent::renderForm();
    }

    /**
     * @todo uses redirectAdmin only if !$this->ajax
     */
    public function postProcess()
    {
        parent::postProcess();
    }
}
