<?php
/**
 *
 *  2018-2018 Kiliba
 *
 *  @author    Kiliba <support@kiliba.com>
 *  @copyright 2018 Kiliba
 *  @license Kiliba
 *
 *  AI in Digital Marketing
 *
 */

require_once(dirname(__FILE__).'/../../kiliba.php');

class KilibaCronModuleFrontController extends ModuleFrontController
{
    protected $toApi;
    /** @var Kiliba */
    public $module;
    protected $moduleName;

    public function __construct()
    {
        $this->context = Context::getContext();
        $this->context->controller = $this;
        $this->toApi = new KilibaApi();
        $this->module = Module::getInstanceByName(Tools::getValue('module'));
        $this->moduleName = $this->module->name;
    }

    public function init()
    {
        if (!KilibaApi::checkToken(Tools::getValue('token'))) {
            KilibaApi::cutWithError('Token invalide');
        }

        $begin = true;
        $tokenSync = null;

        //GET NUM PAGES ALREADY TREATED
        $idsToTreat = array(
            "customers" => (int)Tools::getValue('customers'),
            "orders" => (int)Tools::getValue('orders'),
            "carts" => (int)Tools::getValue('carts'),
            "products" => (int)Tools::getValue('products'),
            "specificprices" => (int)Tools::getValue('specificprices'),
            "countries" => (int)Tools::getValue('countries'),
        );

        $tokenSync = Tools::getValue('tokenSync', null);

        if (($idsToTreat["customers"] > 0 ||
            $idsToTreat["orders"] > 0 ||
            $idsToTreat["products"] > 0 ||
            $idsToTreat["carts"] > 0 ||
            $idsToTreat["specificprices"] > 0 ||
            $idsToTreat["countries"] > 0) &&
            $idsToTreat["customers"] !== -1 &&
            $idsToTreat["orders"] !== -1 &&
            $idsToTreat["products"] !== -1 &&
            $idsToTreat["carts"] !== -1 &&
            $idsToTreat["specificprices"] !== -1
            && $idsToTreat["countries"] !== -1) {
            $begin = false;
            if (empty($tokenSync) ||
                $tokenSync != Configuration::get('TO_TOKEN_SYNC', null, null, Context::getContext()->shop->id)) {
                KilibaApi::cutWithError('TokenSync invalide', 'error_token_sync');
            }
        }

        $params = array( "begin" => $begin, "idsToTreat" => $idsToTreat);

        // SYNC NOT ACTIVE
        if ($this->module->isSyncActive() !== false) {
            KilibaApi::cutWithError('Sync already active', 'error_already_sync_active');
        }

        try {
            Configuration::updateValue('ACTIVE_SYNCHRO', "1", null, null, Context::getContext()->shop->id);
            $result = $this->module->installationSync($params);
            Configuration::updateValue('ACTIVE_SYNCHRO', "0", null, null, Context::getContext()->shop->id);
        } catch (Exception $e) {
            Configuration::updateValue('ACTIVE_SYNCHRO', "0", null, null, Context::getContext()->shop->id);
            KilibaApi::cutWithError($e->getMessage());
        }

        $this->module->toCaller->sendRequest("MEMORY PEAK USAGE: ".(memory_get_peak_usage(true)/1024/1024)." MiB\n\n");

        if (false === $result['success']) {
            $message = $result["error"];
            $this->module->toCaller->sendRequest($message);

            $toLog = new KilibaLog();
            $toLog->process = 'cron.php';
            $toLog->message = json_encode($result);
            $toLog->type = KilibaLog::LOG_TYPE_ERROR;
            $toLog->save();

            KilibaApi::cutWithError($message, $result['errorCode'], $result['payload']);
        }

        if (true === $result['success'] && $result['payload']['fullyCompleted']) {
            $toLog = new KilibaLog();
            $toLog->process = 'cron.php';
            $toLog->message = json_encode($result);
            $toLog->type = KilibaLog::LOG_TYPE_INFO;
            $toLog->save();
            $this->toApi->cutWithSuccess($result['payload']);
        }

        // SEND NEXT CALL
        $responseCallSync = $this->module->toCaller->callSync($tokenSync);
        $result['payload']['responseCallSync'] = $responseCallSync['response']['success'];
        $result['payload']['cronUrl'] = $responseCallSync['cronInfos']['url'];

        $this->toApi->cutWithSuccess($result['payload']);
    }
}
