<?php
/**
 *
 *  2018-2018 Kiliba
 *
 *  @author    Kiliba <support@kiliba.com>
 *  @copyright 2018 Kiliba
 *  @license Kiliba
 *
 *  AI in Digital Marketing
 *
 */

require_once(dirname(__FILE__).'/../../kiliba.php');

class AdminToLoggerController extends ModuleAdminController
{
    public function __construct()
    {
        $this->bootstrap = true;
        $this->required_database = true;
        $this->table = 'to_log';
        $this->className = 'KilibaLog';
        $this->identifier = 'id_log';

        $this->context    = Context::getContext();
        $this->allow_export   = true;
        $this->actions_available = array( 'list' );
        parent::__construct();

        $this->fields_list = array(
            'id_log' => array(
                'title'  => $this->l('ID'),
                'align' => 'center',
                'type'   => 'text',
            ),
            'type' => array(
                'title'  => $this->l('Type'),
                'align' => 'center',
                'type'   => 'text',
            ),
            'process' => array(
                'title' => $this->l('Process name'),
                'align' => 'center',
                'havingFilter' => true,
            ),
            'date_add' => array(
                'title' => $this->l('Date'),
                'align' => 'center',
                'havingFilter' => true,
            ),
            'message' => array(
                'title' => $this->l('Message'),
                'align' => 'center',
                'havingFilter' => true,
            ),
        );
    }

    public function initToolbar()
    {
        parent::initToolbar();
        if (isset($this->toolbar_btn['new'])) {
            unset($this->toolbar_btn['new']);
        }
    }

    public function displayRequiredFields()
    {
        return '';
    }
}
