<?php
/**
 *
 *  2018-2018 Kiliba
 *
 *  @author    Kiliba <support@kiliba.com>
 *  @copyright 2018 Kiliba
 *  @license Kiliba
 *
 *  AI in Digital Marketing
 *
 */

class KilibaQuerySpecificPrices extends KilibaQueryAbstract
{
    protected $configurationKey = 'SPECIFICPRICE';
    protected $tableName = 'specific_price';
    protected $topic = 'promotions';

    public function __construct($shop = null)
    {
        parent::__construct($shop);

        if (!!Configuration::get('TO_BATCH_SIZE_'.$this->getConfigurationKey(), null, null, $this->shop->id)) {
            $this->batchSize = Configuration::get(
                'TO_BATCH_SIZE_'.$this->getConfigurationKey(),
                null,
                null,
                $this->shop->id
            );
        }
    }

    public function getSchema()
    {
        return json_encode(array("type" => "record", "name" => "Promotions", "fields" => array(
            array("name" => "id_specific_price", "type" => "string"),
            array("name" => "id_specific_price_rule", "type" => "string"),
            array("name" => "id_cart", "type" => "string"),
            array("name" => "id_product", "type" => "string"),
            array("name" => "id_shop", "type" => "string"),
            array("name" => "id_shop_group", "type" => "string"),
            array("name" => "id_currency", "type" => "string"),
            array("name" => "id_country", "type" => "string"),
            array("name" => "id_group", "type" => "string"),
            array("name" => "id_customer", "type" => "string"),
            array("name" => "id_product_attribute", "type" => "string"),
            array("name" => "price", "type" => "string"),
            array("name" => "from_quantity", "type" => "string"),
            array("name" => "reduction", "type" => "string"),
            array("name" => "reduction_tax", "type" => "string"),
            array("name" => "reduction_type", "type" => "string"),
            array("name" => "from", "type" => "string"),
            array("name" => "to", "type" => "string")
        )));
    }

    public function getData()
    {
        $id = $this->getLastId();

        $result = Db::getInstance()->executeS('
             SELECT *
             FROM `'._DB_PREFIX_.'specific_price` `a`
             WHERE `a`.`id_specific_price` > '.(int)$id.'
             AND (`a`.`id_shop` = '.(int)$this->shop->id.' OR `a`.`id_shop` = 0 OR
             `id_shop_group` = '.(int)$this->shop->id_shop_group.')
             AND (`a`.`to` >= "'.date('Y-m-d H:i:s').'" OR `a`.`to` = "0000-00-00 00:00:00")
             ORDER BY `a`.`id_specific_price` ASC
             LIMIT '.(int) $this->batchSize);

        return $result;
    }

    public function count($id = 0)
    {
        $result = Db::getInstance()->getValue('
             SELECT COUNT(*)
             FROM `'._DB_PREFIX_.'specific_price` `a`
             WHERE `a`.`id_specific_price` > '.(int)$id.'
             AND (`a`.`id_shop` = '.(int)$this->shop->id.' OR `a`.`id_shop` = 0 OR
             `id_shop_group` = '.(int)$this->shop->id_shop_group.')
             AND (`a`.`to` >= "'.date('Y-m-d H:i:s').'" OR `a`.`to` = "0000-00-00 00:00:00")');

        return $result;
    }

    private function executeData($data)
    {
        $count_specificprice = $this->getCount();
        $errorsInRow = $last_id_specificprice = 0;

        $records = array();
        foreach ($data as $row) {
            $records_to_add = $this->prepareData($row);
            $records = array_merge($records, $records_to_add);

            $count_specificprice++;
            $last_id_specificprice = (int)$row['id_specific_price'];
        }

        $success = false;
        while ($errorsInRow < $this->maxErrorsInRow && $success == false) {
            $result = $this->kilibaCaller->postKafka(
                $this->topic,
                $this->getSchema(),
                $this->getSchemaKey(),
                $records,
                true
            );
            if ($result == false) {
                $errorsInRow = $errorsInRow + 1;
                sleep(1);
                continue;
            }

            $success = true;
            $errorsInRow = 0;
        }

        if (!$success) {
            $this->setError(true);
            return false;
        }

        sleep(1);

        $this->setLastId($last_id_specificprice);
        $this->setCount($count_specificprice);
        return true;
    }

    public function execute()
    {
        $data = $this->getData();
        if (empty($data)) {
            $this->setHasNextResults(false);
            return true;
        }

        if (count($data) < $this->batchSize) {
            $this->setHasNextResults(false);
        } else {
            $this->setHasNextResults();
        }

        return $this->executeData($data);
    }

    public function prepareData($row)
    {
        $record = array();
        $record['id_specific_price'] = (string)$row['id_specific_price'];
        $record['id_specific_price_rule'] = (string)$row['id_specific_price_rule'];
        $record['id_cart'] = (string)$row['id_cart'];
        $record['id_product'] = (string)$row['id_product'];
        $record['id_shop'] = (string)$row['id_shop'];
        $record['id_shop_group'] = (string)$row['id_shop_group'];
        $record['id_currency'] = (string)$row['id_currency'];
        $record['id_country'] = (string)$row['id_country'];
        $record['id_group'] = (string)$row['id_group'];
        $record['id_customer'] = (string)$row['id_customer'];
        $record['id_product_attribute'] = (string)$row['id_product_attribute'];
        $record['price'] = (string)$row['price'];
        $record['from_quantity'] = (string)$row['from_quantity'];
        $record['reduction'] = (string)$row['reduction'];
        $record['reduction_tax'] = (string) (isset($row['reduction_tax']) ? $row['reduction_tax'] : 0);
        $record['reduction_type'] = (string)$row['reduction_type'];
        $record['from'] = (string)$row['from'];
        $record['to'] = (string)$row['to'];

        return array(array("value" => $record, "key" => array("id" => $this->getIdAccount())));
    }
}
