<?php
/**
 *
 *  2018-2018 Kiliba
 *
 *  @author    Kiliba <support@kiliba.com>
 *  @copyright 2018 Kiliba
 *  @license Kiliba
 *
 *  AI in Digital Marketing
 *
 */

class KilibaQueryCountries extends KilibaQueryAbstract
{
    protected $configurationKey = 'COUNTRIES';
    protected $tableName = 'country';
    protected $topic = 'countries';

    public function __construct($shop = null)
    {
        parent::__construct($shop);
    }

    public function getSchema()
    {
        return json_encode(array("type" => "record", "name" => "Countries", "fields" => array(
            array("name" => "id_country", "type" => "string"),
            array("name" => "iso_code", "type" => "string"),
        )));
    }

    public function getData()
    {
        $result = Db::getInstance()->executeS(
            'SELECT `id_country`, `iso_code` FROM `'._DB_PREFIX_.'country` ORDER BY `id_country` ASC'
        );

        return $result;
    }

    public function count($id = 0)
    {
        return (int) Db::getInstance()->getValue('SELECT COUNT(*) FROM `'._DB_PREFIX_.'country` ');
    }

    public function executeData($data)
    {
        $errorsInRow = 0;

        $records = array();
        foreach ($data as $row) {
            $records_to_add = $this->prepareData($row);
            $records = array_merge($records, $records_to_add);
        }

        $last_records = end($data);
        $last_id_country = $last_records['id_country'];
        $count_country = count($data);
        unset($data);

        $success = false;
        while ($errorsInRow < $this->maxErrorsInRow && $success == false) {
            $result = $this->kilibaCaller->postKafka(
                $this->topic,
                $this->getSchema(),
                $this->getSchemaKey(),
                $records,
                true
            );
            if ($result == false) {
                $errorsInRow = $errorsInRow + 1;
                sleep(1);
                continue;
            }

            $success = true;
            $errorsInRow = 0;
        }

        if (!$success) {
            $this->setError(true);
            return false;
        }

        sleep(1);

        $this->setLastId($last_id_country);
        $this->setCount($count_country);
    }

    public function execute()
    {
        $data = $this->getData();

        /** Car on fait tout en une fois */
        $this->setHasNextResults(false);
        $this->setHasResults();

        return $this->executeData($data);
    }

    public function prepareData($row)
    {
        $record = array();
        $record['id_country'] = (string)$row['id_country'];
        $record['iso_code'] = (string)$row['iso_code'];

        return array(array("value" => $record, "key" => array("id" => $this->getIdAccount())));
    }
}
