<?php
/**
 *
 *  2018-2018 Kiliba
 *
 *  @author    Kiliba <support@kiliba.com>
 *  @copyright 2018 Kiliba
 *  @license Kiliba
 *
 *  AI in Digital Marketing
 *
 */

abstract class KilibaQueryAbstract
{
    /** @var Shop */
    protected $shop;
    /** @var KilibaCaller  */
    protected $kilibaCaller;
    /** @var int  */
    protected $batchSize = 50;
    /** @var int  */
    protected $maxErrorsInRow = 10;
    /** @var bool  */
    protected $error = false;
    /** @var bool  */
    protected $errorParams = array();
    /** @var bool  */
    protected $hasResults = false;
    /** @var string  */
    protected $hasNextResult = false;

    protected $configurationKey = '';
    protected $tableName = '';
    protected $topic = '';

    public function __construct($shop = null)
    {
        if ($shop === null) {
            $shop = Context::getContext()->shop;
        }
        $this->shop = $shop;
        $this->kilibaCaller = new KilibaCaller();

        if (!!Configuration::get('TO_BATCH_SIZE_GLOBAL', null, null, $this->shop->id)) {
            $this->batchSize = (int) Configuration::get('TO_BATCH_SIZE_GLOBAL', null, null, $this->shop->id);
        }
    }

    public function getSchemaKey()
    {
        return json_encode(
            array("type" => "record", "name" => "Key", "fields" => array(array("name" => "id", "type" => "string")))
        );
    }

    public function getIdAccount()
    {
        return (string) Configuration::get('ID_ACCOUNT_THATSOWL', null, null, $this->shop->id);
    }

    public function getConfigurationKey()
    {
        return Tools::strtoupper($this->configurationKey);
    }

    public function isFinished()
    {
        return (bool) !Configuration::get('TO_BATCH_'.$this->getConfigurationKey().'_DO', null, null, $this->shop->id);
    }

    public function setFinished($finished = true)
    {
        if ($finished) {
            Configuration::updateValue(
                'TO_BATCH_'.$this->getConfigurationKey().'_DO',
                false,
                null,
                null,
                $this->shop->id
            );
            return;
        }

        Configuration::updateValue('TO_BATCH_'.$this->getConfigurationKey().'_DO', true, null, null, $this->shop->id);
    }

    public function getLastId()
    {
        return (int) Configuration::get('TO_LAST_'.$this->getConfigurationKey().'_ID', null, null, $this->shop->id);
    }

    public function setLastId($id)
    {
        Configuration::updateValue(
            'TO_LAST_'.$this->getConfigurationKey().'_ID',
            (int)$id,
            false,
            null,
            $this->shop->id
        );
    }

    public function getCount()
    {
        return (int) Configuration::get(
            'TO_BATCH_'.$this->getConfigurationKey().'_COUNT',
            null,
            null,
            $this->shop->id
        );
    }

    public function setCount($count)
    {
        Configuration::updateValue(
            'TO_BATCH_'.$this->getConfigurationKey().'_COUNT',
            (int)$count,
            false,
            null,
            $this->shop->id
        );
    }

    public function getTotal()
    {
        $tableName = $this->tableName;
        return KilibaCache::getCached('TOTAL_'.$this->getConfigurationKey(), function () use ($tableName) {
            return (int)Kiliba::getTotalNoOfTable($tableName);
        });
    }

    public function setTotal($count)
    {
        Configuration::updateValue(
            'TO_BATCH_'.$this->getConfigurationKey().'_COUNT',
            (int)$count,
            false,
            null,
            $this->shop->id
        );
    }

    public function setError($error, $params = array())
    {
        $this->error = $error;
        $this->errorParams = $params;
    }

    public function getErrorParams()
    {
        return $this->errorParams;
    }

    public function hasError()
    {
        return (bool)$this->error;
    }

    public function hasResults()
    {
        return (bool)$this->hasResults;
    }

    public function setHasNextResults($hasNextResult = true)
    {
        $this->hasNextResult = (bool) $hasNextResult;
    }

    public function hasNextResults()
    {
        return $this->hasNextResult;
    }

    public function setHasResults($hasResults = true)
    {
        return $this->hasResults = (bool)$hasResults;
    }
}
