<?php
/**
 *
 *  2018-2018 Kiliba
 *
 *  @author    Kiliba <support@kiliba.com>
 *  @copyright 2018 Kiliba
 *  @license Kiliba
 *
 *  AI in Digital Marketing
 *
 */

use Sabre\Xml;
use Sabre\Xml\XmlSerializable;

class ProductEntry implements XmlSerializable
{
    public $id;

    public function xmlSerialize(Sabre\Xml\Writer $writer)
    {
        $kiliba = new Kiliba();
        $id_shop = Context::getContext()->shop->id;
        $id_account = Configuration::get('ID_ACCOUNT_THATSOWL', null, null, $id_shop);
        $records = $kiliba->prepareProduct($this->id, null, false);
        foreach ($records as $record) {
            foreach ($record as $row) {
                foreach ($row as $name => $value) {
                    if (is_array($value) && in_array('name', $value)) {
                        $writer->startElement('name');//name
                        foreach ($value as $k => $v) {
                            $writer->write([
                                'name' => $k, //fr
                                'value' => $v //T-shirt
                            ]);
                        }
                        $writer->endElement();
                    } elseif (is_array($value) && in_array('reductions', $value)) {
                        $writer->startElement('reductions');
                        foreach ($value as $k => $v) {
                            $writer->write([
                                'name' => $k,
                                'value' => $v
                            ]);
                        }
                        $writer->endElement();
                    } elseif ($name == 'id' && $value == $id_account) {
                        $writer->write([
                            'name' => 'id_account',
                            'value' => $value
                        ]);
                    } else {
                        $writer->write([
                            'name' => $name,
                            'value' => $value
                        ]);
                    }
                }
            }
        }
    }
}
