<?php
/**
 *
 *  2018-2018 Kiliba
 *
 *  @author    Kiliba <support@kiliba.com>
 *  @copyright 2018 Kiliba
 *  @license Kiliba
 *
 *  AI in Digital Marketing
 *
 */

class KilibaLog extends ObjectModel
{
    const LOG_TYPE_INFO = 'info';
    const LOG_TYPE_WARNING = 'warning';
    const LOG_TYPE_ERROR = 'error';

    public $type;
    public $process;
    public $message;
    public $date_add;

    public static $definition = array(
        'table' => 'to_log',
        'primary' => 'id_log',
        'fields' => array(
            'type'     => array('type' => self::TYPE_STRING, 'validate' => 'isString'),
            'process' => array('type' => self::TYPE_STRING, 'validate' => 'isString'),
            'message'  => array('type' => self::TYPE_STRING, 'validate' => 'isString'),
            'date_add'  => array('type' => self::TYPE_DATE, 'validate' => 'isDate'),
        ),
    );

    public function add($autodate = true, $null_values = false)
    {
        $configuration = ConfigurationCore::get(
            'TO_DEBUG_MOD',
            null,
            Context::getContext()->shop->id_shop_group,
            Context::getContext()->shop->id
        );

        if (!in_array($configuration, array(
            self::LOG_TYPE_INFO,
            self::LOG_TYPE_WARNING,
            self::LOG_TYPE_ERROR,
        ))) {
            return true;
        }

        if ($configuration == self::LOG_TYPE_ERROR) {
            if ($this->type == self::LOG_TYPE_INFO
                || $this->type == self::LOG_TYPE_WARNING) {
                return true;
            }
        }
        if ($configuration == self::LOG_TYPE_WARNING) {
            if ($this->type == self::LOG_TYPE_INFO) {
                return true;
            }
        }

        return parent::add($autodate, $null_values);
    }

    public static function bulkAdd($logs)
    {
        if (!empty($logs)) {
            $query = array_map(function ($elem) {
                return '( "' . pSQL($elem['type']) . '", "'
                    . pSQL($elem['process']) . '", "'
                    . pSQL($elem['message']) . '", "'
                    . pSQL($elem['date_add']) . '")';
            }, $logs);

            Db::getInstance()->execute(
                'INSERT INTO '._DB_PREFIX_.'to_log
                (`type`, `process`, `message`, `date_add`) VALUES '.implode(',', $query).''
            );
        }
    }

    public static function getLogsForExport()
    {
        $logs = Db::getInstance()->executeS('SELECT * FROM '._DB_PREFIX_.'to_log ORDER BY date_add DESC');
        if (!$logs) {
            $logs = array();
        }

        return $logs;
    }

    public static function clean(DateTime $before_date)
    {
        $collection = new Collection('ToLog');
        $collection->where('date_add', '<', $before_date->format('Y-m-d H:i:s'));
        $results = $collection->getResults();
        $nb_results  = count($results);
        if ($nb_results > 0) {
            foreach ($results as $result) {
                $result->delete();
            }
        }

        $newLog = new KilibaLog();
        $newLog->type = self::LOG_TYPE_INFO;
        $newLog->process = 'cleanLog';
        $newLog->message = 'suppression des log créés avant le '.$before_date->format('Y-m-d H:i:s');
        $newLog->add();

        return $nb_results;
    }
}
