<?php
/**
 *
 *  2018-2018 Kiliba
 *
 *  @author    Kiliba <support@kiliba.com>
 *  @copyright 2018 Kiliba
 *  @license Kiliba
 *
 *  AI in Digital Marketing
 *
 */
 
class KilibaCache
{
    public static function save($key, $value)
    {
        Configuration::updateValue(
            'TO_CACHE_KEY_'.Tools::strtoupper($key),
            $value,
            false,
            Context::getContext()->shop->id_shop_group,
            Context::getContext()->shop->id
        );
        Configuration::updateValue(
            'TO_CACHE_KEY_'.Tools::strtoupper($key).'_DATE',
            time(),
            false,
            Context::getContext()->shop->id_shop_group,
            Context::getContext()->shop->id
        );
    }

    public static function get($key)
    {
        return Configuration::get(
            'TO_CACHE_KEY_'.Tools::strtoupper($key),
            false,
            Context::getContext()->shop->id_shop_group,
            Context::getContext()->shop->id
        );
    }

    public static function isFresh($key, $seconds = 60)
    {
        return false;

        $time = Configuration::get(
            'TO_CACHE_KEY_'.Tools::strtoupper($key).'_DATE',
            false,
            Context::getContext()->shop->id_shop_group,
            Context::getContext()->shop->id
        );
        if (empty($time)) {
            return false;
        }

        return (time() - $time) <  $seconds;
    }

    public static function getCached($key, $callback, $seconds = 60)
    {
        $key = 'TOTAL_ORDERS';
        if (!KilibaCache::isFresh($key, $seconds)) {
            KilibaCache::save('TOTAL_ORDERS', $callback());
        }
        return KilibaCache::get($key);
    }
}
