<?php
/**
 *
 *  2018-2018 Kiliba
 *
 *  @author    Kiliba <support@kiliba.com>
 *  @copyright 2018 Kiliba
 *  @license Kiliba
 *
 *  AI in Digital Marketing
 *
 */

class KilibaAutolog
{
    public static function findCustomerByToken($token)
    {
        $token_parts = explode('_', $token);
        if (count($token_parts) != 2) {
            return false;
        }

        $id_customer = $token_parts[0];

        $id_customer = Db::getInstance()->getValue('SELECT id_customer
            FROM '._DB_PREFIX_.'customer
            WHERE id_customer = '.(int)$id_customer.'');

        if (!$id_customer) {
            return false;
        }

        $customer = new Customer($id_customer);

        $customerToken = self::buildCustomerToken($customer);
        if ($customerToken != $token) {
            return false;
        }

        return $customer;
    }

    public static function buildCustomerToken($customer)
    {
        $TOtoken = Configuration::get(
            'KILIBA_FLUX_TOKEN',
            null,
            Context::getContext()->shop->id_shop_group,
            Context::getContext()->shop->id
        );
        return $customer->id.'_'.md5($customer->id.$customer->secure_key.$TOtoken);
    }

    public static function isOrderedCart($id_cart)
    {
        return Db::getInstance()->getValue('SELECT id_order
                FROM '._DB_PREFIX_.'orders o
                WHERE o.`id_cart` = '.(int)$id_cart.'');
    }

    public static function login($customer, $id_cart = null)
    {
        if (empty($id_cart)|| !Validate::isInt($id_cart)) {
            $id_cart = null;
        }

        $context = Context::getContext();
        $context->cookie->id_compare = isset($context->cookie->id_compare) ?
            $context->cookie->id_compare :
            CompareProduct::getIdCompareByIdCustomer($customer->id);
        $context->cookie->id_customer = (int)($customer->id);
        $context->cookie->customer_lastname = $customer->lastname;
        $context->cookie->customer_firstname = $customer->firstname;
        $context->cookie->logged = 1;
        $customer->logged = 1;
        $context->cookie->is_guest = $customer->isGuest();
        $context->cookie->passwd = $customer->passwd;
        $context->cookie->email = $customer->email;

        // Add customer to the context
        $context->customer = $customer;

        if (!empty($id_cart) &&
            (empty($context->cookie->id_cart) ||
            Cart::getNbProducts($context->cookie->id_cart) == 0) &&
            !self::isOrderedCart($id_cart)) {
            $context->cart = new Cart($id_cart);
        } elseif (Configuration::get('PS_CART_FOLLOWING') &&
            (empty($context->cookie->id_cart)
                || Cart::getNbProducts($context->cookie->id_cart) == 0)
            && $id_cart = (int)Cart::lastNoneOrderedCart($context->customer->id)) {
            $context->cart = new Cart($id_cart);
        } else {
            if (version_compare(_PS_VERSION_, '1.7') > 0) {
                $idCarrier = (int) $context->cart->id_carrier;
            }
            $context->cart->id_carrier = 0;
            $context->cart->setDeliveryOption(null);
            if (version_compare(_PS_VERSION_, '1.7') > 0) {
                $context->cart->updateAddressId(
                    $context->cart->id_address_delivery,
                    (int)Address::getFirstCustomerAddressId((int)($customer->id))
                );
            }
            $context->cart->id_address_delivery = Address::getFirstCustomerAddressId((int)($customer->id));
            $context->cart->id_address_invoice = Address::getFirstCustomerAddressId((int)($customer->id));
        }

        $context->cart->id_customer = (int)$customer->id;
        if (version_compare(_PS_VERSION_, '1.7') > 0) {
            if (isset($idCarrier) && $idCarrier) {
                $deliveryOption = array($context->cart->id_address_delivery => $idCarrier . ',');
                $context->cart->setDeliveryOption($deliveryOption);
            }
        }
        $context->cart->secure_key = $customer->secure_key;
        $context->cart->save();
        $context->cookie->id_cart = (int)$context->cart->id;
        $context->cookie->write();
        $context->cart->autosetProductAddress();

        Hook::exec('actionAuthentication');

        // Login information have changed, so we check if the cart rules still apply
        CartRule::autoRemoveFromCart($context);
        CartRule::autoAddToCart($context);
    }
}
