<?php
/**
 *
 *  2018-2018 Kiliba
 *
 *  @author    Kiliba <support@kiliba.com>
 *  @copyright 2018 Kiliba
 *  @license Kiliba
 *
 *  AI in Digital Marketing
 *
 */

class KilibaApi
{
    public static function checkToken($token)
    {
        if ($token === Configuration::get('KILIBA_FLUX_TOKEN')) {
            return true;
        }

        return false;
    }

    public static function cutWithError($error = '', $errorCode = '', $payload = array())
    {
        echo json_encode(array(
            'error' => $error,
            'errorCode' => $errorCode,
            'success' => false,
            'payload' => $payload
        ));
        exit;
    }

    public function getApiUrl($shop = null, $params = array())
    {
        if ($shop === null) {
            $shop = Context::getContext()->shop;
        }

        return Context::getContext()->link->getModuleLink(
            Kiliba::$moduleName,
            'api',
            array_merge(array( 'token' => Configuration::get('KILIBA_FLUX_TOKEN') ), $params),
            null,
            null,
            $shop->id
        );
    }

    public function cutWithSuccess($payload = array())
    {
        echo json_encode(array(
            'error' => false,
            'success' => true,
            'payload' => $payload
        ));
        exit;
    }

    public function deleteLogs(DateTime $dateTime)
    {
        $numberLogDeleted = KilibaLog::clean($dateTime);

        $this->cutWithSuccess(array(
           'message' => $numberLogDeleted.' logs supprimés'
        ));
    }

    public function getLogs($format)
    {
        $logs = KilibaLog::getLogsForExport();
        switch ($format) {
            case 'csv':
                header('Content-Type: application/csv');
                header('Content-Disposition: attachment; filename=logs.csv');
                header('Pragma: no-cache');

                $fp = fopen('php://output', 'w');

                foreach ($logs as $log) {
                    fputcsv($fp, $log, "|", '"');
                }
                fclose($fp);
                break;
            default:
                foreach ($logs as $k => $log) {
                    $logs[$k]['message'] = json_decode($log['message'], true);
                    if (json_last_error() !== JSON_ERROR_NONE) {
                        // Some logs are added in plain text
                        $logs[$k]['message'] = $log['message'];
                    }
                }

                $this->cutWithSuccess($logs);
                break;
        }
        if ($format === "csv") {
            exit();
        }
    }
}
