
# Plug Kiliba Prestashop

1. Installation du module

    Lors de l'inscription sur la plateforme That's Owl, un ID vous sera attribué.
    Ce meme ID est à entrée dans le panel de configuration du module Kiliba.
    La synchro va alors commencer.

    PS: Une fois la synchronisation lancée, vous pouvez suivre son avancement sur votre compte Kiliba.

2. Fonctionnalités

**Général**
- [x] Envoi des données vers KafkaRest à l'aide d'un schema Avro.
- [x] Utilisation de l'id du compte Kiliba dans le format d'envoi.

**Synchronisation initiale**
- [x] Récupération des produits
- [x] Récupération des commandes
- [x] Récupération des clients
- [x] Récupération des paniers
- [x] Récupération des promotions
- [x] Récupération des pays
- [x] Import automatisé du logo

 **Hooks d'action**
  - [x] Mise à jour des produits (CRUD)
  - [x] Mise à jour des commandes (CRUD)
  - [x] Mise à jour des clients (CRUD)
  - [x] Mise à jour des paniers (CRUD)
  - [x] Pages visitées (clients uniquement)

**Generation d'un flux produit XML**

Il existe deux modes de remontés la liste des produits. En passant par KAFKA ou en générant les produits par XML.

Par défaut avec KAFKA (et le système de hook), ceci peut être changé par génération XML avec l'appel API suivant :
`&action=setConfiguration&configuration=KILIBA_TO_GENERATE_MODE&value=xml`

Et la possibilité de revenir à une génération par hook :
`&action=setConfiguration&configuration=KILIBA_TO_GENERATE_MODE&value=hook` 

La generation d'un flux XML se fait en appelant le controller suivant avec le token associé :
`/module/kiliba/xml?token={TOKEN}`

Ceci peut être lancé par cron à l'interval souhaité. Il est recommandé de le faire toutes les 6 heures pour limiter l'impact sur les performances de l'hébergement.

L'appel au cron va générer un fichier XML récupérable à la racine du module :
`{accountID}_products.xml`

La génération du flux se fait par itération avec CURL afin d'éviter que le process PHP ou la requête HTML ne timeout.

Pour cela 150 produits sont générés par défaut à chaque itération. Il est possible de changer ce paramètre en changant la configuration de `KILIBA_XML_NB_PRODUCT_ITERATOR`
Ce paramètre doit être variable suivant les performances de l'environnement. Il est conseiller de mettre un nombre élevé de produit (par exemple 500) si les capacités le permettent afin de réduire le nombre de requêtes SQL.

Une sécurité est également ajoutée afin d'éviter que deux exports se fassent par erreur en parallèle. Pour cela, le délai minimal est configuré sur `KILIBA_XML_MINIMAL_INTERVAL`.

**Api**

Différentes routes API sont appelables en tapant sur le fichier api.php du plug: url du type <BASE_URL>/modules/kiliba/api.php
Cette routes demandent un token pour fonctionner (paramètre de requête `token`) ainsi que de préciser l'action désirée (paramètre de requête `action`), ainsi que d'éventuels paramètres additionnels, voici la liste des routes définies et leurs paramètres liés.

Variables de conf utilisées par le plug:
- KILIBA_FLUX_TOKEN
- DONE_SYNCHRO
- ID_ACCOUNT_THATSOWL
- KAFKA_REST_PASSWORD
- ACTIVE_SYNCHRO
- PAGES_PRODUCT
- PAGES_ORDER
- PAGES_CUSTOMER
- PAGES_CART
- TO_DEBUG_MOD ( info, warning, error, 0 )
- TO_HOOK_UPDATE_DISABLED
- TO_DURATION_SYNCH_INIT
- TO_DURATION_SYNCH
- TO_BATCH_PRODUCT_NO_ATTRIBUTES
- TO_TOKEN_SYNC
- TO_BATCH_SIZE_PRODUCT
- TO_BATCH_SIZE_GLOBAL
- TO_LAST_PRODUCT_ID
- TO_LAST_ORDER_ID
- TO_LAST_CUSTOMER_ID
- TO_LAST_CART_ID
- TO_BATCH_PRODUCT_COUNT
- TO_BATCH_ORDER_COUNT
- TO_BATCH_CUSTOMER_COUNT
- TO_BATCH_CART_COUNT
- TO_BATCH_PRODUCT_DO
- TO_BATCH_ORDER_DO
- TO_BATCH_CUSTOMER_DO
- TO_BATCH_CART_DO
- TO_BATCH_SPECIFICPRICE_DO
- TO_BATCH_COUNTRIES_DO
- TO_SPECIFIC_PRICE_LIMIT
- TO_CURL_TIMEOUT
- TO_CURL_CONNECTTIMEOUT_MS
- TO_CURL_CONNECTTIMEOUT_MS_VISITS
- KILIBA_TO_GENERATE_MODE : hook ou XML (voir "Generation d'un flux produit XML")
- KILIBA_XML_MINIMAL_INTERVAL : Le delai minimal en secondes à respecter entre deux generation de flux
- KILIBA_XML_LAST_CALL : La date du dernier appel GET ou CURL pour la generation du flux
- KILIBA_LAST_UPD_FILE : La date de la dernière mise à jour du flux XML
- KILIBA_XML_NB_PRODUCT_ITERATOR : Le nombre de produit à gérérer sur le flux par itération 

| Action | Description| Paramètres additionnels (OPT = optionnel) | Exemple |
| --- | --- | --- | --- |
| getLog |Récupérer les logs stockés dans la BDD du prestashop|format|api.php?action=getLog&token=1234&format=csv|
| deleteLog |Supprimer les logs dans la BDD du prestashop | from_date | api.php?action=deleteLog&token=token&from_date=2019-01-13|
|setConfiguration|Modifier une variable de configuration du module| configuration, value | api.php?action=setConfiguration&token=token&configuration=DONE_SYNCHRO&value=1|
|debug|Récupérer la valeur des variables de configuration ainsi que le statut des hooks||api.php?action=debug&token=token|
|hook|Permet d'activer ou de desactiver un hook|hookName, hookAction|  api.php?action=hook&token=1234&hookName=displayFooter&hookAction=unregister|
|try|Permet de tester l'envoi d'une donnée d'une table avec son id|tryType, tryId|api.php?action=try&token=1234&tryType=order&tryId=42|

**ChangeLog**

- Fix remontée grosses commandes
