<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a commercial license from SARL DREAM ME UP
 * Use, copy, modification or distribution of this source file without written
 * license agreement from the SARL DREAM ME UP is strictly forbidden.
 *
 *   .--.
 *   |   |.--..-. .--, .--.--.   .--.--. .-.   .  . .,-.
 *   |   ;|  (.-'(   | |  |  |   |  |  |(.-'   |  | |   )
 *   '--' '   `--'`-'`-'  '  `-  '  '  `-`--'  `--`-|`-'
 *        w w w . d r e a m - m e - u p . f r       '
 *
 * @author    Dream me up <prestashop@dream-me-up.fr>
 * @copyright 2007 - 2017 Dream me up
 * @license   All Rights Reserved
 */

abstract class Db extends DbCore
{
    public $queries = array();
    public $total_time_queries = 0;
    public $total_nb_queries = 0;
    
    public function query($sql)
    {
        $start = microtime(true);

        // Execute query
        $result = parent::query($sql);

        $end = microtime(true);

        $time = round((float)(($end - $start)*1000));
        $this->total_time_queries += $time;
        $this->total_nb_queries++;

        if (!preg_match('`2pa_cache_call`iUs', $sql) && $time >= 50) {
            $stack = debug_backtrace(false);
            while (preg_match('@[/\\\\]classes[/\\\\]db[/\\\\]@i', $stack[0]['file'])) {
                array_shift($stack);
            }
            $stack_light = array();
            foreach ($stack as $call) {
                $stack_light[] = array( 'file' => isset($call['file']) ? $call['file'] : 'undefined',
                                        'line' => isset($call['line']) ? $call['line'] : 'undefined');
            }
            
            $this->queries[] = array(
                'query' => trim($sql),
                'time' => $time,
                'stack' => $stack_light,
                'date_query' => date("Y-m-d H:i:s")
            );
        }
        return $result;
    }
}
