<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a commercial license from SARL DREAM ME UP
 * Use, copy, modification or distribution of this source file without written
 * license agreement from the SARL DREAM ME UP is strictly forbidden.
 *
 *   .--.
 *   |   |.--..-. .--, .--.--.   .--.--. .-.   .  . .,-.
 *   |   ;|  (.-'(   | |  |  |   |  |  |(.-'   |  | |   )
 *   '--' '   `--'`-'`-'  '  `-  '  '  `-`--'  `--`-|`-'
 *        w w w . d r e a m - m e - u p . f r       '
 *
 * @author    Dream me up <prestashop@dream-me-up.fr>
 * @copyright 2007 - 2017 Dream me up
 * @license   All Rights Reserved
 */

class Hook extends HookCore
{
    public static function exec(
        $hook_name,
        $hook_args = array(),
        $id_module = null,
        $array_return = false,
        $check_exceptions = true,
        $use_push = false,
        $id_shop = null,
        $chain = false
    ) {
        if (file_exists(_PS_MODULE_DIR_."dmu2panalytics/classes/PpaHook.php")) {
            $memoryUsage = memory_get_usage();
            $t0 = microtime(true);

            include_once(_PS_MODULE_DIR_."dmu2panalytics/classes/PpaHook.php");

            if (version_compare(_PS_VERSION_, '1.6', '<')) {
                $result = PpaHook::exec15(
                    $hook_name,
                    $hook_args,
                    $id_module,
                    $array_return,
                    $check_exceptions
                );
            } elseif (version_compare(_PS_VERSION_, '1.7', '<')) {
                $result = PpaHook::exec16(
                    $hook_name,
                    $hook_args,
                    $id_module,
                    $array_return,
                    $check_exceptions,
                    $use_push,
                    $id_shop
                );
            } elseif (version_compare(_PS_VERSION_, '1.7', '>=')) {
                $result = PpaHook::exec17(
                    $hook_name,
                    $hook_args,
                    $id_module,
                    $array_return,
                    $check_exceptions,
                    $use_push,
                    $id_shop,
                    $chain
                );
            }

            PpaHook::$hookTime[$hook_name] = round((float)((microtime(true)- $t0)*1000));
            PpaHook::$hookMemoryUsage[$hook_name] = memory_get_usage() - $memoryUsage;
            return $result;
        } else {
            // Sécurité au cas ou le module est supprimé sans être désinstallé
            $frontcontroller = Tools::file_get_contents(_PS_OVERRIDE_DIR_."controller/FrontController.php");
            if (preg_match("`extends PpaFrontController`iUs", $frontcontroller)) {
                file_put_contents(
                    _PS_OVERRIDE_DIR_."controller/FrontController.php",
                    str_replace("extends PpaFrontController", "extends FrontControllerCore", $frontcontroller)
                );
            }

            return parent::exec(
                $hook_name,
                $hook_args,
                $id_module,
                $array_return,
                $check_exceptions,
                $use_push,
                $id_shop,
                $chain
            );
        }
    }
}
