<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a commercial license from SARL DREAM ME UP
 * Use, copy, modification or distribution of this source file without written
 * license agreement from the SARL DREAM ME UP is strictly forbidden.
 *
 *   .--.
 *   |   |.--..-. .--, .--.--.   .--.--. .-.   .  . .,-.
 *   |   ;|  (.-'(   | |  |  |   |  |  |(.-'   |  | |   )
 *   '--' '   `--'`-'`-'  '  `-  '  '  `-`--'  `--`-|`-'
 *        w w w . d r e a m - m e - u p . f r       '
 *
 * @author    Dream me up <prestashop@dream-me-up.fr>
 * @copyright 2007 - 2017 Dream me up
 * @license   All Rights Reserved
 */

if (!defined('_PS_VERSION_')) {
    exit;
}

class Dmu2Panalytics extends Module
{
    protected $retour_2pa;
    protected $retour_process;

    public function __construct()
    {
        $this->name = 'dmu2panalytics';
        $this->tab = 'analytics_stats';
        $this->version = '1.5.9';
        $this->author = 'Dream me up';
        $this->module_key = '5ca24de5f16149c286cfd1a451252f10';
        $this->need_instance = 0;
        $this->bootstrap = true;

        parent::__construct();

        $this->displayName = $this->l('2P Analytics : Prestashop Performance Analytics');
        $this->description = $this->l('Short Description');

        $this->confirmUninstall = $this->l('Are you sure you want to uninstall ?');

        // Onglets à afficher dans la configuration (mettre un tableau vide si pas de config)
        $this->config_tabs = array(
            'TestInstall' => array(     'name' => $this->l('Install Test'),
                                        'is_helper' => false),
            'Configuration' => array(   'name' => $this->l('Configuration'),
                                        'is_helper' => true));
    }

    /* Configuration du module */
    public function getContent()
    {
        include_once("classes/PpaEndPoint.php");

        $this->retour_process = $this->postProcess();

        $ppa = new PpaEndPoint();
        $this->retour_2pa = json_decode($ppa->testIdSiteLicence(Configuration::get('dmu2pa_id_site')));

        $iso = $this->context->language->iso_code;

        if (!empty($this->retour_2pa) && is_object($this->retour_2pa)) {
            if ((int)$this->retour_2pa->error == 1) {
                $this->context->smarty->assign(array("ppa_is_configured" => false));
            }
        }

        $this->context->smarty->assign(
            array(
                'config_tabs' => $this->config_tabs,
                'version_prestashop' => _PS_VERSION_,
                'version_module' => $this->version,
                'nom_module' => $this->displayName,
                'path_module' => '../modules/'.$this->name.'',

                'form_id' => ((Tools::getValue('form_id') != '')?Tools::getValue('form_id'):''),

                'path_documentation' => 'documentation_'.($iso == 'fr' ? $iso : 'en').'.pdf',

                // Textes traductibles à ne pas modifier
                'txt_module_version' => $this->l('Module version'),
                'txt_howto' => $this->l('How to use this module ?'),
                'txt_click_here' => $this->l('Click here to access the menu'),
                'txt_qui' => $this->l('Who are we ?'),
                'txt_notre_site' => $this->l('Our website'),
                'txt_notre' => $this->l('Our'),
                'txt_page' => $this->l('Prestashop Partner dedicated page'),
                'txt_decouvrez' => $this->l('Discover all our modules on our'),
                'txt_addons_page' => $this->l('Prestashop Addons dedicated page'),
                'txt_support' => $this->l('Support and Documentation'),
                'txt_open_doc' => $this->l('Click Here to open the module documentation'),
                'txt_support_only' => $this->l('If you encounter any issue using this module'),
                'txt_interm' => $this->l('please contact us'),
                'txt_mention' => $this->l('You must mention'),
                'txt_desc_problem' => $this->l('A detailed description of the problem'),
                'txt_version_presta' => $this->l('Your Prestashop Version'),
                'txt_version_module' => $this->l('Your Module Version'),
                'txt_follow' => $this->l('Follow us'),
                'txt_follow_our' => $this->l('Follow our'),
                'txt_on' => $this->l('on'),
                'txt_and' => $this->l('and'),
                'txt_know_actu' => $this->l('to know all the news around our Addons'),
                'txt_to_have_details' =>
                   $this->l('to have all details on our new Addons versions and for every new launch of Addon'),

                // Liens
                'lnk_page_prestashop' => $this->l('http://addons.prestashop.com/en/9_dream-me-up'),

                'content_html' => array(
                    // Il faut ajouter ici les différentes fonctions pour chaque onglet
                    'TestInstall' => $this->testInstall(),
                    'Configuration' => $this->getConfigurationForm(),
                ),
            )
        );

        if (version_compare(_PS_VERSION_, '1.6', '<')) {
            $this->context->smarty->assign(array("is_old_version" => true));
        }

        return $this->context->smarty->fetch(dirname(__FILE__).'/views/templates/admin/configure.tpl');
    }

    public function testInstall()
    {
        if (!empty($this->retour_2pa) && is_object($this->retour_2pa)) {
            if ((int)$this->retour_2pa->error == 1) {
                return false;
            }
        }

        $array_errors = array();

        $frontcontroller = Tools::file_get_contents(
            _PS_OVERRIDE_DIR_."classes/controller/FrontController.php"
        );

        $hookclass = Tools::file_get_contents(
            _PS_OVERRIDE_DIR_."classes/Hook.php"
        );

        $dbclass = Tools::file_get_contents(
            _PS_OVERRIDE_DIR_."classes/db/Db.php"
        );

        // Test des surcharges
        $disable_overrides = (int)Configuration::get('PS_DISABLE_OVERRIDES');
        if ($disable_overrides == 1) {
            $array_errors[] = $this->l('Override are disabled, our addon can\'t work if this option is disabled, please enable Overrides in Advanced Parameters / Performances');
        }

        if (!preg_match("`extends PpaFrontController`iUs", $frontcontroller)) {
            $array_errors[] = $this->l('Override in FrontController.php is missing');
        }

        if (!preg_match("`PpaHook`iUs", $hookclass)) {
            $array_errors[] = $this->l('Override in Hook.php is missing');
        }

        if (!preg_match("`2pa_cache_call`iUs", $dbclass)) {
            $array_errors[] = $this->l('Override in Db.php is missing');
        }

        // Test de l'existance de la table
        $sql = "SHOW TABLES FROM "._DB_NAME_." LIKE '"._DB_PREFIX_."2pa_cache_call'";
        $row = Db::getInstance()->ExecuteS($sql);
        if (empty($row)) {
            $array_errors[] = $this->l('Important SQL table is not existing');
        }

        // Fichier FrontController mal placé
        if (file_exists(_PS_OVERRIDE_DIR_."controllers/front/FrontController.php")) {
            $array_errors[] = $this->l(
                'File FrontController in /override/controllers/front/FrontController.php should not exists !'
            );
        }

        $this->context->smarty->assign(array("array_errors" => $array_errors));

        return $this->context->smarty->fetch(dirname(__FILE__).'/views/templates/admin/errors_2p.tpl');
    }

    /* Fonction à personnaliser en fonction des besoins en configuration */
    public function getConfigurationForm()
    {
        $config = array('id_site' => Configuration::get('dmu2pa_id_site'),
                        'active' => Configuration::get('dmu2pa_active'),
                        'js_errors' => Configuration::get('dmu2pa_js_errors'),
                        'form_id' => 'Configuration');

        $helper = new HelperForm();
        $helper->show_toolbar = false;
        $helper->table = $this->table;

        $fields_form = array();
        $fields_form[0]['form'] = array();

        // Champs du formulaire
        if (version_compare(_PS_VERSION_, '1.6', '>=')) {
            $fields_form[0]['form']['legend'] = array(
                'title' => $this->l('Module configuration'),
                'icon' => 'icon-cogs'
            );
        }

        if (version_compare(_PS_VERSION_, '1.6', '<')) {
            $type_switch = 'radio';
        } else {
            $type_switch = 'switch';
        }

        $fields_form[0]['form']['input'] = array(
                array('type' => 'hidden', 'name' => 'form_id'),
                array(
                    'type' => 'text',
                    'label' => $this->l('Website ID'),
                    'name' => 'id_site',
                    'hint' => $this->l('You will find it in your 2P Analytics customer area'),
                    'desc' => $this->l('You first need to register on www.2p-analytics.com'),
                    'required' => true,
                    'size' => 100
                ),
                array(
                    'type' => $type_switch,
                    'label' => $this->l('Activate the addon'),
                    'name' => 'active',
                    'required' => true,
                    'is_bool' => true,
                    'values' => array(
                        array( 'id' => 'active', 'value' => 1, 'label' => ''),
                        array( 'id' => 'active', 'value' => 0, 'label' => ''),
                    )
                ),
                array(
                    'type' => $type_switch,
                    'label' => $this->l('Disable JavaScript report'),
                    'name' => 'js_errors',
                    'desc' => $this->l('Reporting JavaScript errors can negatively impact your Core Vitals web score. You can enable this option only when needed.'),
                    'required' => true,
                    'is_bool' => true,
                    'values' => array(
                        array( 'id' => 'active', 'value' => 1, 'label' => ''),
                        array( 'id' => 'active', 'value' => 0, 'label' => ''),
                    )
                )
            );

        $libelle_field = "description";
        if (!empty($this->retour_2pa) && is_object($this->retour_2pa)) {
            if (version_compare(_PS_VERSION_, '1.6', '>=')) {
                $libelle_field = "success";
                if ((int)$this->retour_2pa->error == 1) {
                    $libelle_field = "error";
                }
            }

            $fields_form[0]['form'][$libelle_field] = "2P Analytics : ".$this->retour_2pa->msg;
        } else {
            if (version_compare(_PS_VERSION_, '1.6', '>=')) {
                $libelle_field = "error";
            }
            $fields_form[0]['form'][$libelle_field] = "2P Analytics : Impossible de communiquer avec le serveur";
        }

        $fields_form[0]['form']['submit'] = array(
                'title' => $this->l('Save'),
                'name' => 'submitConfig',
                'class' => (version_compare(_PS_VERSION_, '1.6', '>=') ? 'btn btn-default pull-right' : 'button')
            );

        // Module, token and currentIndex
        $helper->identifier = $this->identifier;
        $helper->submit_action = 'Configuration';
        $helper->currentIndex = $this->context->link->getAdminLink('AdminModules', false).
            '&configure='.$this->name.
            '&tab_module='.$this->tab.
            '&module_name='.$this->name;
        $helper->token = Tools::getAdminTokenLite('AdminModules');
        $helper->tpl_vars = array(
            'fields_value' => $config,
            'languages' => $this->context->controller->getLanguages(),
            'id_language' => $this->context->language->id
        );

        // Title and toolbar
        $helper->title = $this->displayName;
        $helper->show_toolbar = false;
        $helper->toolbar_scroll = false;

        return $this->retour_process.$helper->generateForm($fields_form);
    }

    /*  Gestion des processus en post */
    public function postProcess()
    {
        if (Tools::isSubmit('submitConfig')) {
            $id_site = Tools::getValue('id_site');
            $ppa = new PpaEndPoint();

            if ($ppa->validIdSite($id_site)) {
                Configuration::updateValue('dmu2pa_id_site', $id_site);
                Configuration::updateValue('dmu2pa_active', Tools::getValue('active'));
                Configuration::updateValue('dmu2pa_js_errors', Tools::getValue('js_errors'));

                return $this->displayConfirmation($this->l('Configuration updated'));
            } else {
                Configuration::updateValue('dmu2pa_active', Tools::getValue('active'));

                return $this->displayError($this->l('Your Website ID is not correct'));
            }
        }

        if (Tools::isSubmit('empty_cache_2p')) {
            if (version_compare(_PS_VERSION_, '1.6', '<')) {
                @unlink(dirname(dirname(dirname(__FILE__))).'/cache/class_index.php');
            } else {
                Tools::clearSmartyCache();
                Tools::clearXMLCache();
                Media::clearCache();
                Tools::generateIndex();
            }
        }
    }

    public function hookdisplayHeader()
    {
        include_once("classes/PpaEndPoint.php");
        
        $ep = new PpaEndPoint();
        
        $path_module = __PS_BASE_URI__."modules/dmu2panalytics/";

        $token_js = Tools::getAdminToken(
            $path_module.'views/js/js-error.js'
        );

        $token_2p = Tools::getAdminToken(
            $path_module.'views/js/2p-analytics.js'
        );

        if (version_compare(_PS_VERSION_, '1.7', '>=')) {
            $this->context->controller->registerJavascript(
                'modules-dmu2panalytics',
                'modules/'.$this->name.'/views/js/2p-analytics.js',
                ['position' => 'bottom', 'priority' => 0]
            );
        }

        $this->smarty->assign(array("module_path" => $path_module,
                                    "token_js" => $token_js,
                                    "token_2p" => $token_2p,
                                    "js_errors_disabled" => Configuration::get('dmu2pa_js_errors'),
                                    "is_17" => version_compare(_PS_VERSION_, '1.7', '>='),
                                    "client_2p" => $ep->getIdClient()));
        return $this->display(__FILE__, 'header.tpl');
    }

    public function hookNewOrder($params)
    {
        include_once("classes/PpaEndPoint.php");

        $order = $params['order'];
        $cart = new Cart($order->id_cart);
    
        $total_order = (float)$cart->getOrderTotal();

        $products = $order->getProducts();

        $nb_products = 0;
        foreach ($products as $product) {
            $nb_products += (int)$product['product_quantity'];
        }

        $ep = new PpaEndPoint();
        $ep->addOrder($order->id, $order->id_cart, $total_order, $nb_products);
    }

    public function install()
    {
        $sql = "DROP TABLE IF EXISTS `"._DB_PREFIX_."2pa_cache_call`;
        CREATE TABLE IF NOT EXISTS `"._DB_PREFIX_."2pa_cache_call` (
          `id_cache_call` bigint(16) NOT NULL AUTO_INCREMENT,
          `id_client` varchar(32) DEFAULT NULL,
          `postdata` longtext,
          `time_call` varchar(32) DEFAULT NULL,
          PRIMARY KEY (`id_cache_call`)
        );";

        // Installation du module
        if (!parent::install() || !$this->registerHook('header') || !$this->registerHook('footer')
            || !$this->registerHook('newOrder') || !Db::getInstance()->Execute($sql)) {
            return false;
        }

        // Module actif par défaut
        Configuration::updateValue('dmu2pa_active', 1);

        // Override FrontController
        $this->installFrontController();

        if (version_compare(_PS_VERSION_, '1.6', '<')) {
            @unlink(dirname(dirname(dirname(__FILE__))).'/cache/class_index.php');
        } else {
            Tools::clearSmartyCache();
            Tools::clearXMLCache();
            Media::clearCache();
            Tools::generateIndex();
        }

        return true;
    }

    public function installFrontController()
    {
        $path = _PS_OVERRIDE_DIR_."classes/controller/FrontController.php";
        $frontcontroller = Tools::file_get_contents($path);
        
        if (!file_exists(_PS_OVERRIDE_DIR_."classes/controller/FrontController.php")) {
            $frontcontroller = Tools::file_get_contents(_PS_MODULE_DIR_."dmu2panalytics/classes/FrontController.php");
            file_put_contents(
                $path,
                $frontcontroller
            );
        } elseif (empty($frontcontroller)) {
            $frontcontroller = Tools::file_get_contents(_PS_MODULE_DIR_."dmu2panalytics/classes/FrontController.php");
            file_put_contents(
                $path,
                $frontcontroller
            );
        } else {
            $frontcontroller = str_replace(
                "<?php",
                '<?php'."\r\n".'if (file_exists(_PS_MODULE_DIR_."'.
                'dmu2panalytics/classes/PpaFrontController.php")) {'.
                "\r\n".'include_once(_PS_MODULE_DIR_."'.
                'dmu2panalytics/classes/PpaFrontController.php");'.
                "\r\n".'}',
                $frontcontroller
            );

            if (preg_match("`extends FrontControllerCore`iUs", $frontcontroller)) {
                $frontcontroller = str_replace(
                    "extends FrontControllerCore",
                    "extends PpaFrontController",
                    $frontcontroller
                );
            }

            file_put_contents($path, $frontcontroller);
        }
    }

    public function uninstall()
    {
        $sql = "DROP TABLE IF EXISTS `"._DB_PREFIX_."2pa_cache_call`;";

        // Désinstallation du module
        if (!parent::uninstall() || !Db::getInstance()->Execute($sql)) {
            return false;
        }

        // Override FrontController
        $this->uninstallFrontController();

        if (version_compare(_PS_VERSION_, '1.6', '<')) {
            @unlink(dirname(dirname(dirname(__FILE__))).'/cache/class_index.php');
        } else {
            Tools::clearSmartyCache();
            Tools::clearXMLCache();
            Media::clearCache();
            Tools::generateIndex();
        }

        return true;
    }

    public function uninstallFrontController()
    {
        $path = _PS_OVERRIDE_DIR_."classes/controller/FrontController.php";
        $frontcontroller = Tools::file_get_contents($path);
        
        $frontcontroller = str_replace(
            'if (file_exists(_PS_MODULE_DIR_."'.
            'dmu2panalytics/classes/PpaFrontController.php")) {'.
            "\r\n".'include_once(_PS_MODULE_DIR_."'.
            'dmu2panalytics/classes/PpaFrontController.php");'.
            "\r\n".'}',
            '',
            $frontcontroller
        );

        if (preg_match("`extends PpaFrontController`iUs", $frontcontroller)) {
            $frontcontroller = str_replace(
                "extends PpaFrontController",
                "extends FrontControllerCore",
                $frontcontroller
            );
        }

        file_put_contents($path, $frontcontroller);
    }
}
