<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a commercial license from SARL DREAM ME UP
 * Use, copy, modification or distribution of this source file without written
 * license agreement from the SARL DREAM ME UP is strictly forbidden.
 *
 *   .--.
 *   |   |.--..-. .--, .--.--.   .--.--. .-.   .  . .,-.
 *   |   ;|  (.-'(   | |  |  |   |  |  |(.-'   |  | |   )
 *   '--' '   `--'`-'`-'  '  `-  '  '  `-`--'  `--`-|`-'
 *        w w w . d r e a m - m e - u p . f r       '
 *
 * @author    Dream me up <prestashop@dream-me-up.fr>
 * @copyright 2007 - 2017 Dream me up
 * @license   All Rights Reserved
 */

use PrestaShop\PrestaShop\Adapter\SymfonyContainer;
use PrestaShop\PrestaShop\Core\Module\WidgetInterface;

class PpaHook extends HookCore
{
    public static $hookTime = array();
    public static $hookModuleTime = array();
    public static $hookMemoryUsage = array();
    
    public static function getHookTime()
    {
        return self::$hookTime;
    }
    
    public static function getHookModuleTime()
    {
        return self::$hookModuleTime;
    }
    
    public static function getHookMemoryUsage()
    {
        return self::$hookMemoryUsage;
    }

    public static function exec17(
        $hook_name,
        $hook_args = array(),
        $id_module = null,
        $array_return = false,
        $check_exceptions = true,
        $use_push = false,
        $id_shop = null,
        $chain = false
    ) {
if (defined('PS_INSTALLATION_IN_PROGRESS')) {
            return;
        }

        $hookRegistry = self::getHookRegistryPpa();
        $isRegistryEnabled = null !== $hookRegistry;

        if ($isRegistryEnabled) {
            $backtrace = debug_backtrace(DEBUG_BACKTRACE_IGNORE_ARGS, 1);
            $hookRegistry->selectHook($hook_name, $hook_args, $backtrace[0]['file'], $backtrace[0]['line']);
        }

        // $chain & $array_return are incompatible so if chained is set to true, we disable the array_return option
        if (true === $chain) {
            $array_return = false;
        }

        static $disable_non_native_modules = null;
        if ($disable_non_native_modules === null) {
            $disable_non_native_modules = (bool) Configuration::get('PS_DISABLE_NON_NATIVE_MODULE');
        }

        // Check arguments validity
        if (($id_module && !is_numeric($id_module)) || !Validate::isHookName($hook_name)) {
            throw new PrestaShopException('Invalid id_module or hook_name');
        }

        // If no modules associated to hook_name or recompatible hook name, we stop the function

        if (!$module_list = self::getHookModuleExecList($hook_name)) {
            if ($isRegistryEnabled) {
                $hookRegistry->collect();
            }
            if ($array_return) {
                return array();
            } else {
                return '';
            }
        }

        // Check if hook exists
        if (!$id_hook = self::getIdByName($hook_name)) {
            if ($isRegistryEnabled) {
                $hookRegistry->collect();
            }
            if ($array_return) {
                return array();
            } else {
                return false;
            }
        }

        if (array_key_exists($hook_name, self::$deprecated_hooks)) {
            $deprecVersion = isset(self::$deprecated_hooks[$hook_name]['from']) ?
                    self::$deprecated_hooks[$hook_name]['from'] :
                    _PS_VERSION_;
            Tools::displayAsDeprecated('The hook ' . $hook_name . ' is deprecated in PrestaShop v.' . $deprecVersion);
        }

        // Store list of executed hooks on this page
        self::$executed_hooks[$id_hook] = $hook_name;

        $context = Context::getContext();
        if (!isset($hook_args['cookie']) || !$hook_args['cookie']) {
            $hook_args['cookie'] = $context->cookie;
        }
        if (!isset($hook_args['cart']) || !$hook_args['cart']) {
            $hook_args['cart'] = $context->cart;
        }

        // Look on modules list
        $altern = 0;
        if ($array_return) {
            $output = array();
        } else {
            $output = '';
        }

        if ($disable_non_native_modules && !isset(self::$native_module)) {
            self::$native_module = Module::getNativeModuleList();
        }

        $different_shop = false;
        if ($id_shop !== null && Validate::isUnsignedId($id_shop) && $id_shop != $context->shop->getContextShopID()) {
            $old_context = $context->shop->getContext();
            $old_shop = clone $context->shop;
            $shop = new Shop((int) $id_shop);
            if (Validate::isLoadedObject($shop)) {
                $context->shop = $shop;
                $context->shop->setContext(Shop::CONTEXT_SHOP, $shop->id);
                $different_shop = true;
            }
        }

        foreach ($module_list as $key => $array) {
            $t0 = microtime(true);

            // Check errors
            if ($id_module && $id_module != $array['id_module']) {
                continue;
            }

            if ((bool) $disable_non_native_modules && self::$native_module && count(self::$native_module) && !in_array($array['module'], self::$native_module)) {
                continue;
            }

            // Check permissions
            if ($check_exceptions) {
                $exceptions = Module::getExceptionsStatic($array['id_module'], $array['id_hook']);

                $controller_obj = Context::getContext()->controller;
                if ($controller_obj === null) {
                    $controller = null;
                } else {
                    $controller = isset($controller_obj->controller_name) ?
                                $controller_obj->controller_name :
                                $controller_obj->php_self;
                }

                //check if current controller is a module controller
                if (isset($controller_obj->module) && Validate::isLoadedObject($controller_obj->module)) {
                    $controller = 'module-' . $controller_obj->module->name . '-' . $controller;
                }

                if (in_array($controller, $exceptions)) {
                    continue;
                }

                //Backward compatibility of controller names
                $matching_name = array(
                    'authentication' => 'auth',
                );
                if (isset($matching_name[$controller]) && in_array($matching_name[$controller], $exceptions)) {
                    continue;
                }
                if (Validate::isLoadedObject($context->employee) && !Module::getPermissionStatic($array['id_module'], 'view', $context->employee)) {
                    continue;
                }
            }

            if (!($moduleInstance = Module::getInstanceByName($array['module']))) {
                continue;
            }

            if ($use_push && !$moduleInstance->allow_push) {
                continue;
            }

            if ($isRegistryEnabled) {
                $hookRegistry->hookedByModule($moduleInstance);
            }

            if (self::isHookCallableOnPpa($moduleInstance, $hook_name)) {
                $hook_args['altern'] = ++$altern;

                if ($use_push && isset($moduleInstance->push_filename) && file_exists($moduleInstance->push_filename)) {
                    Tools::waitUntilFileIsModified($moduleInstance->push_filename, $moduleInstance->push_time_limit);
                }

                if (0 !== $key && true === $chain) {
                    $hook_args = $output;
                }

                $display = self::callHookOnPpa($moduleInstance, $hook_name, $hook_args);

                if ($array_return) {
                    $output[$moduleInstance->name] = $display;
                } else {
                    if (true === $chain) {
                        $output = $display;
                    } else {
                        $output .= $display;
                    }
                }
                if ($isRegistryEnabled) {
                    $hookRegistry->hookedByCallback($moduleInstance, $hook_args);
                }

                // DMU Performances Analytics
                $time_module = round((float)((microtime(true)- $t0)*1000));

                if ($time_module > 10) {
                    if (!isset(PpaHook::$hookModuleTime[$hook_name])) {
                        PpaHook::$hookModuleTime[$hook_name] = array();
                    }
                    
                    PpaHook::$hookModuleTime[$hook_name][$array['module']] = $time_module;
                }

            } elseif (self::isDisplayHookName($hook_name)) {
                if ($moduleInstance instanceof WidgetInterface) {
                    if (0 !== $key && true === $chain) {
                        $hook_args = $output;
                    }

                    $display = self::coreRenderWidget($moduleInstance, $hook_name, $hook_args);

                    if ($array_return) {
                        $output[$moduleInstance->name] = $display;
                    } else {
                        if (true === $chain) {
                            $output = $display;
                        } else {
                            $output .= $display;
                        }
                    }
                }

                if ($isRegistryEnabled) {
                    $hookRegistry->hookedByWidget($moduleInstance, $hook_args);
                }

                // DMU Performances Analytics
                $time_module = round((float)((microtime(true)- $t0)*1000));

                if ($time_module > 10) {
                    if (!isset(PpaHook::$hookModuleTime[$hook_name])) {
                        PpaHook::$hookModuleTime[$hook_name] = array();
                    }
                    
                    PpaHook::$hookModuleTime[$hook_name][$array['module']] = $time_module;
                }
            }
        }

        if ($different_shop) {
            $context->shop = $old_shop;
            $context->shop->setContext($old_context, $shop->id);
        }

        if (true === $chain) {
            if (isset($output['cookie'])) {
                unset($output['cookie']);
            }
            if (isset($output['cart'])) {
                unset($output['cart']);
            }
        }

        if ($isRegistryEnabled) {
            $hookRegistry->hookWasCalled();
            $hookRegistry->collect();
        }

        return $output;
    }

    public static function exec16(
        $hook_name,
        $hook_args = array(),
        $id_module = null,
        $array_return = false,
        $check_exceptions = true,
        $use_push = false,
        $id_shop = null
    ) {
        if (defined('PS_INSTALLATION_IN_PROGRESS')) {
            return;
        }

        static $disable_non_native_modules = null;
        if ($disable_non_native_modules === null) {
            $disable_non_native_modules = (bool)Configuration::get('PS_DISABLE_NON_NATIVE_MODULE');
        }

        // Check arguments validity
        if (($id_module && !is_numeric($id_module)) || !Validate::isHookName($hook_name)) {
            throw new PrestaShopException('Invalid id_module or hook_name');
        }

        // If no modules associated to hook_name or recompatible hook name, we stop the function

        if (!$module_list = self::getHookModuleExecList($hook_name)) {
            return '';
        }

        // Check if hook exists
        if (!$id_hook = self::getIdByName($hook_name)) {
            return false;
        }

        // Store list of executed hooks on this page
        self::$executed_hooks[$id_hook] = $hook_name;

        $live_edit = false;
        $context = Context::getContext();
        if (!isset($hook_args['cookie']) || !$hook_args['cookie']) {
            $hook_args['cookie'] = $context->cookie;
        }
        if (!isset($hook_args['cart']) || !$hook_args['cart']) {
            $hook_args['cart'] = $context->cart;
        }

        $retro_hook_name = self::getRetroHookName($hook_name);

        // Look on modules list
        $altern = 0;
        $output = '';

        if ($disable_non_native_modules && !isset(self::$native_module)) {
            self::$native_module = Module::getNativeModuleList();
        }

        $different_shop = false;
        if ($id_shop !== null && Validate::isUnsignedId($id_shop) && $id_shop != $context->shop->getContextShopID()) {
            $old_context = $context->shop->getContext();
            $old_shop = clone $context->shop;
            $shop = new Shop((int)$id_shop);
            if (Validate::isLoadedObject($shop)) {
                $context->shop = $shop;
                $context->shop->setContext(Shop::CONTEXT_SHOP, $shop->id);
                $different_shop = true;
            }
        }

        foreach ($module_list as $array) {
            $t0 = microtime(true);

            // Check errors
            if ($id_module && $id_module != $array['id_module']) {
                continue;
            }

            if ((bool)$disable_non_native_modules && self::$native_module
                && count(self::$native_module) && !in_array($array['module'], self::$native_module)) {
                continue;
            }

            if (!($moduleInstance = Module::getInstanceByName($array['module']))) {
                continue;
            }

            // Check permissions
            if ($check_exceptions) {
                $exceptions = $moduleInstance->getExceptions($array['id_module'], $array['id_hook']);

                $controller = Dispatcher::getInstance()->getController();
                $controller_obj = Context::getContext()->controller;

                //check if current controller is a module controller
                if (isset($controller_obj->module) && Validate::isLoadedObject($controller_obj->module)) {
                    $controller = 'module-'.$controller_obj->module->name.'-'.$controller;
                }

                if (in_array($controller, $exceptions)) {
                    continue;
                }

                //Backward compatibility of controller names
                $matching_name = array(
                    'authentication' => 'auth',
                    'productscomparison' => 'compare'
                );
                if (isset($matching_name[$controller]) && in_array($matching_name[$controller], $exceptions)) {
                    continue;
                }
                if (Validate::isLoadedObject($context->employee)
                    && !Module::getPermissionStatic($array['id_module'], 'view', $context->employee)) {
                    continue;
                }
            }

            if (!($moduleInstance = Module::getInstanceByName($array['module']))) {
                continue;
            }

            if ($use_push && !$moduleInstance->allow_push) {
                continue;
            }
            // Check which / if method is callable
            $hook_callable = is_callable(array($moduleInstance, 'hook'.$hook_name));
            $hook_retro_callable = is_callable(array($moduleInstance, 'hook'.$retro_hook_name));

            if (($hook_callable || $hook_retro_callable) && Module::preCall($moduleInstance->name)) {
                $hook_args['altern'] = ++$altern;

                if ($use_push && isset($moduleInstance->push_filename) && file_exists($moduleInstance->push_filename)) {
                    Tools::waitUntilFileIsModified($moduleInstance->push_filename, $moduleInstance->push_time_limit);
                }

                // Call hook method
                if ($hook_callable) {
                    $display = $moduleInstance->{'hook'.$hook_name}($hook_args);
                } elseif ($hook_retro_callable) {
                    $display = $moduleInstance->{'hook'.$retro_hook_name}($hook_args);
                }

                // Live edit
                if (!$array_return && $array['live_edit'] && Tools::isSubmit('live_edit') && Tools::getValue('ad')
                    && Tools::getValue('liveToken') == Tools::getAdminToken('AdminModulesPositions'
                        .(int)Tab::getIdFromClassName('AdminModulesPositions').(int)Tools::getValue('id_employee'))) {
                    $live_edit = true;
                    $output .= self::wrapLiveEdit($display, $moduleInstance, $array['id_hook']);
                } elseif ($array_return) {
                    $output[$moduleInstance->name] = $display;
                } else {
                    $output .= $display;
                }

                // DMU Performances Analytics
                $time_module = round((float)((microtime(true)- $t0)*1000));

                if ($time_module > 10) {
                    if (!isset(self::$hookModuleTime[$hook_name])) {
                        self::$hookModuleTime[$hook_name] = array();
                    }
                    
                    self::$hookModuleTime[$hook_name][$array['module']] = $time_module;
                }
            }
        }

        if ($different_shop) {
            $context->shop = $old_shop;
            $context->shop->setContext($old_context, $shop->id);
        }

        if ($array_return) {
            return $output;
        } else {
            if ($live_edit) {
                $context->smarty->assign(array( "hook_name" => $hook_name,
                                                "output" => $output));
                return $context->smarty->fetch(dirname(__FILE__).
                    '/../views/templates/hook/hook_override_start.tpl').
                    $output.
                    $context->smarty->fetch(dirname(__FILE__).
                    '/../views/templates/hook/hook_override_end.tpl');
            } else {
                return $output;
            }
        }// Return html string
    }

    public static function exec15(
        $hook_name,
        $hook_args = array(),
        $id_module = null,
        $array_return = false,
        $check_exceptions = true
    ) {
        static $disable_non_native_modules = null;
        if ($disable_non_native_modules === null) {
            $disable_non_native_modules = (bool)Configuration::get('PS_DISABLE_NON_NATIVE_MODULE');
        }

        // Check arguments validity
        if (($id_module && !is_numeric($id_module)) || !Validate::isHookName($hook_name)) {
            throw new PrestaShopException('Invalid id_module or hook_name');
        }

        // If no modules associated to hook_name or recompatible hook name, we stop the function

        if (!$module_list = self::getHookModuleExecList($hook_name)) {
            return '';
        }

        // Check if hook exists
        if (!$id_hook = self::getIdByName($hook_name)) {
            return false;
        }

        // Store list of executed hooks on this page
        self::$executed_hooks[$id_hook] = $hook_name;

        $live_edit = false;
        $context = Context::getContext();
        if (!isset($hook_args['cookie']) || !$hook_args['cookie']) {
            $hook_args['cookie'] = $context->cookie;
        }
        if (!isset($hook_args['cart']) || !$hook_args['cart']) {
            $hook_args['cart'] = $context->cart;
        }

        $retro_hook_name = self::getRetroHookName($hook_name);

        // Look on modules list
        $altern = 0;
        $output = '';

        if ($disable_non_native_modules && !isset(self::$native_module)) {
            self::$native_module = Module::getNativeModuleList();
        }

        foreach ($module_list as $array) {
            $t0 = microtime(true);
            
            // Check errors
            if ($id_module && $id_module != $array['id_module']) {
                continue;
            }

            if ((bool)$disable_non_native_modules && self::$native_module
                && count(self::$native_module) && !in_array($array['module'], self::$native_module)) {
                continue;
            }

            if (!($moduleInstance = Module::getInstanceByName($array['module']))) {
                continue;
            }

            // Check permissions
            if ($check_exceptions) {
                $exceptions = $moduleInstance->getExceptions($array['id_hook']);
                $controller = Dispatcher::getInstance()->getController();

                if (in_array($controller, $exceptions)) {
                    continue;
                }
                
                //retro compat of controller names
                $matching_name = array(
                    'authentication' => 'auth',
                    'compare' => 'products-comparison',
                );
                if (isset($matching_name[$controller]) && in_array($matching_name[$controller], $exceptions)) {
                    continue;
                }
                if (Validate::isLoadedObject($context->employee)
                    && !$moduleInstance->getPermission('view', $context->employee)) {
                    continue;
                }
            }

            // Check which / if method is callable
            $hook_callable = is_callable(array($moduleInstance, 'hook'.$hook_name));
            $hook_retro_callable = is_callable(array($moduleInstance, 'hook'.$retro_hook_name));
            if (($hook_callable || $hook_retro_callable) && Module::preCall($moduleInstance->name)) {
                $hook_args['altern'] = ++$altern;

                // Call hook method
                if ($hook_callable) {
                    $display = $moduleInstance->{'hook'.$hook_name}($hook_args);
                } elseif ($hook_retro_callable) {
                    $display = $moduleInstance->{'hook'.$retro_hook_name}($hook_args);
                }
                // Live edit
                $t = Tools::getAdminToken('AdminModulesPositions'.(int)Tab::getIdFromClassName('AdminModulesPositions').
                    (int)Tools::getValue('id_employee'));
                if (!$array_return && $array['live_edit'] && Tools::isSubmit('live_edit')
                    && Tools::getValue('ad') && Tools::getValue('liveToken') == $t) {
                    $live_edit = true;
                    $output .= self::wrapLiveEdit($display, $moduleInstance, $array['id_hook']);
                } elseif ($array_return) {
                    $output[] = $display;
                } else {
                    $output .= $display;
                }

                // DMU Performances Analytics
                $time_module = round((float)((microtime(true)- $t0)*1000));

                if ($time_module > 10) {
                    if (!isset(\PpaHook::$hookModuleTime[$hook_name])) {
                        \PpaHook::$hookModuleTime[$hook_name] = array();
                    }
                    
                    \PpaHook::$hookModuleTime[$hook_name][$array['module']] = $time_module;
                }
            }
        }
        if ($array_return) {
            return $output;
        } else {
            if ($live_edit) {
                $context->smarty->assign(array( "hook_name" => $hook_name,
                                                "output" => $output));
                return $context->smarty->fetch(dirname(__FILE__).
                    '/../views/templates/hook/hook_override_start.tpl').
                    $output.
                    $context->smarty->fetch(dirname(__FILE__).
                    '/../views/templates/hook/hook_override_end.tpl');
            } else {
                return $output;
            }
        }// Return html string
    }

    private static function getHookAliasesListPpa()
    {
        $cacheId = 'hook_aliases';
        if (!Cache::isStored($cacheId)) {
            $hookAliasList = Db::getInstance()->executeS('SELECT * FROM `'._DB_PREFIX_.'hook_alias`');
            $hookAliases = array();
            if ($hookAliasList) {
                foreach ($hookAliasList as $ha) {
                    if (!isset($hookAliases[$ha['name']])) {
                        $hookAliases[$ha['name']] = array();
                    }
                    $hookAliases[$ha['name']][] = $ha['alias'];
                }
            }
            Cache::store($cacheId, $hookAliases);
            return $hookAliases;
        }
        return Cache::retrieve($cacheId);
    }

    private static function callHookOnPpa($module, $hookName, $hookArgs)
    {
        if (is_callable(array($module, 'hook' . $hookName))) {
            return self::coreCallHook($module, 'hook' . $hookName, $hookArgs);
        }
        foreach (self::getHookAliasesForPpa($hookName) as $hook) {
            if (is_callable(array($module, 'hook' . $hook))) {
                return self::coreCallHook($module, 'hook' . $hook, $hookArgs);
            }
        }

        return '';
    }

    private static function getHookRegistryPpa()
    {
        $sfContainer = SymfonyContainer::getInstance();
        if (null !== $sfContainer && 'dev' === $sfContainer->getParameter('kernel.environment')) {
            return $sfContainer->get('prestashop.hooks_registry');
        }

        return null;
    }

    public static function getMethodNamePpa(string $hookName): string
    {
        return 'hook' . ucfirst($hookName);
    }

    private static function isHookCallableOnPpa($module, $hookName)
    {
        $aliases = self::getHookAliasesForPpa($hookName);
        $aliases[] = $hookName;

        return array_reduce($aliases, function ($prev, $curr) use ($module) {
            return $prev || is_callable(array($module, 'hook' . $curr));
        }, false);
    }

    private static function getHookAliasesForPpa($hookName)
    {
        $cacheId = 'hook_aliases_' . $hookName;
        if (!Cache::isStored($cacheId)) {
            $aliasesList = self::getHookAliasesListPpa();

            if (isset($aliasesList[$hookName])) {
                Cache::store($cacheId, $aliasesList[$hookName]);

                return $aliasesList[$hookName];
            }

            $retroName = array_keys(array_filter($aliasesList, function ($elem) use ($hookName) {
                return in_array($hookName, $elem);
            }));

            if (empty($retroName)) {
                Cache::store($cacheId, array());

                return array();
            }

            Cache::store($cacheId, $retroName);

            return $retroName;
        }

        return Cache::retrieve($cacheId);
    }
}
