<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a commercial license from SARL DREAM ME UP
 * Use, copy, modification or distribution of this source file without written
 * license agreement from the SARL DREAM ME UP is strictly forbidden.
 *
 *   .--.
 *   |   |.--..-. .--, .--.--.   .--.--. .-.   .  . .,-.
 *   |   ;|  (.-'(   | |  |  |   |  |  |(.-'   |  | |   )
 *   '--' '   `--'`-'`-'  '  `-  '  '  `-`--'  `--`-|`-'
 *        w w w . d r e a m - m e - u p . f r       '
 *
 * @author    Dream me up <prestashop@dream-me-up.fr>
 * @copyright 2007 - 2017 Dream me up
 * @license   All Rights Reserved
 */

class PpaFrontController extends FrontControllerCore
{
    public static $session_created = false;
    public $form;
    public static $php_errors;

    public function run()
    {
        if (file_exists(_PS_MODULE_DIR_."dmu2panalytics/classes/PpaEndPoint.php")) {
            include_once(_PS_MODULE_DIR_."dmu2panalytics/classes/PpaEndPoint.php");

            $ppa = new PpaEndPoint();

            $ppa->debugDisplay("PpaFrontController Run");

            // 2P Analytics PHP Error Handler (il prend le dessus sur celui de base)
            set_error_handler(array('PpaFrontController', 'ppaErrorHandler'));
            register_shutdown_function(array('PpaFrontController', 'ppaFatalErrorHandler'));

            $start_total = microtime(true);

            $ppa->startTimer("init", false);
            $this->init();
            $ppa->endTimer("init");
            
            // 2P Analytics PHP Error Handler (on reprend le dessus sur celui de base dans init())
            set_error_handler(array('PpaFrontController', 'ppaErrorHandler'));

            if ($this->checkAccess()) {
                // setMedia MUST be called before postProcess
                if (!$this->content_only && ($this->display_header || (isset($this->className) && $this->className))) {
                    $ppa->startTimer("setMedia", false);
                    $this->setMedia();
                    $ppa->endTimer("setMedia");
                }

                // postProcess handles ajaxProcess
                $ppa->startTimer("postProcess", false);
                $this->postProcess();
                $ppa->endTimer("postProcess");

                if (!empty($this->redirect_after)) {
                    $ppa->startTimer("redirect", false);
                    $this->redirect();
                    $ppa->endTimer("redirect");
                }

                if (!$this->content_only && ($this->display_header || (isset($this->className) && $this->className))) {
                    $ppa->startTimer("initHeader", false);
                    $this->initHeader();
                    $ppa->endTimer("initHeader");
                }

                if ($this->viewAccess()) {
                    $ppa->startTimer("initContent", false);
                    $this->initContent();
                    $ppa->endTimer("initContent");
                } else {
                    if (version_compare(_PS_VERSION_, '1.7', '>=')) {
                        $this->errors[] = $this->trans('Access denied.', array(), 'Admin.Notifications.Error');
                    } else {
                        $this->errors[] = Tools::displayError('Access denied.');
                    }
                }

                if (!$this->content_only && ($this->display_footer || (isset($this->className) && $this->className))) {
                    $ppa->startTimer("initFooter", false);
                    $this->initFooter();
                    $ppa->endTimer("initFooter");
                }

                // Default behavior for ajax process is to use $_POST[action] or $_GET[action]
                // then using displayAjax[action]
                if ($this->ajax) {
                    $action = Tools::toCamelCase(Tools::getValue('action'), true); // TODO : Adapter pour PS 1.5

                    if (!empty($action) && method_exists($this, 'displayAjax'.$action)) {
                        $ppa->startTimer('displayAjax'.$action, false);
                        $this->{'displayAjax'.$action}();
                        $ppa->endTimer('displayAjax'.$action);
                    } elseif (method_exists($this, 'displayAjax')) {
                        $ppa->startTimer('displayAjax', false);
                        $this->displayAjax();
                        $ppa->endTimer('displayAjax');
                    }
                } else {
                    $ppa->startTimer('display', false);
                    $this->display();
                    $ppa->endTimer('display');
                }
            } else {
                $this->initCursedPage();
                $this->smartyOutputContent($this->layout); // TODO : Adapter pour PS 1.5
            }

            $end_total = microtime(true);

            $time_total = round((float)(($end_total - $start_total)*1000));

            if (!$this->ajax && $ppa->validIdSite() && $time_total > 50
                && !preg_match("`\.map$`iUs", $_SERVER['REQUEST_URI'])) {
                $details_pages = $this->getDetailsPage();

                $id_category = 0;
                $id_product = 0;

                if (isset($this->category) && !empty($this->category->id)) {
                    $id_category = $this->category->id;
                }

                if (isset($this->product) && !empty($this->product->id)) {
                    $id_product = $this->product->id;
                }

                $db = Db::getInstance();
                $id_session = $ppa->createSession(
                    $time_total,
                    $details_pages['page_name'],
                    $details_pages['meta_title'],
                    $db->total_time_queries,
                    $db->total_nb_queries,
                    $id_category,
                    $id_product
                );
                self::$session_created = true;

                if ($id_session && !empty(Db::getInstance()->queries)) {
                    foreach (Db::getInstance()->queries as $query) {
                        $ppa->addSql($query);
                    }
                }
                if ($id_session && $time_total > 200) {
                    $hook_module_time = PpaHook::getHookModuleTime();
                    $ppa->setHookModuleTime($hook_module_time);
                }

                // Log des erreurs utilisateurs
                if (version_compare(_PS_VERSION_, '1.7', '>=')) {
                    if (isset($this->form) && !empty($this->form)) {
                        if ($this->form->hasErrors()) {
                            $this->errors = $this->form->getErrors();
                        }
                    }
                }
                
                if (!empty($this->errors)) {
                    $ppa->addErrorPrestashop($this->errors);
                }

                // Log des erreurs PHP
                if (!empty(self::$php_errors)) {
                    $ppa->addPhpError(self::$php_errors);
                }
            }
        } else {
            parent::run();
        }
    }

    public function getDetailsPage()
    {
        if (version_compare(_PS_VERSION_, '1.7', '<')) {
            $module_name = '';
            if (Validate::isModuleName(Tools::getValue('module'))) {
                $module_name = Tools::getValue('module');
            }

            if (!empty($this->page_name)) {
                $page_name = $this->page_name;
            } elseif (!empty($this->php_self)) {
                $page_name = $this->php_self;
            } elseif (Tools::getValue('fc') == 'module' && $module_name != ''
                && (Module::getInstanceByName($module_name) instanceof PaymentModule)) {
                $page_name = 'module-payment-submit';
            } elseif (preg_match('#^'.preg_quote($this->context->shop->physical_uri, '#').
                'modules/([a-zA-Z0-9_-]+?)/(.*)$#', $_SERVER['REQUEST_URI'], $m)) {
                $page_name = 'module-'.$m[1].'-'.str_replace(array('.php', '/'), array('', '-'), $m[2]);
            } else {
                $page_name = Dispatcher::getInstance()->getController();
                $page_name = (preg_match('/^[0-9]/', $page_name) ? 'page_'.$page_name : $page_name);
            }
            $meta_title = $this->context->smarty->getTemplateVars('meta_title');
        } else {
            $page = $this->getTemplateVarPage();
            $page_name = $page['page_name'];
            $meta_title = $page['meta']['title'];
        }

        return array('page_name' => $page_name, 'meta_title' => $meta_title);
    }

    protected function makeLoginForm()
    {
        $this->form = new CustomerLoginForm(
            $this->context->smarty,
            $this->context,
            $this->getTranslator(),
            new CustomerLoginFormatter($this->getTranslator()),
            $this->getTemplateVarUrls()
        );

        $this->form->setAction($this->getCurrentURL());

        return $this->form;
    }

    protected function makeAddressForm()
    {
        if (Configuration::get('PS_RESTRICT_DELIVERED_COUNTRIES')) {
            $availableCountries = Carrier::getDeliveredCountries($this->context->language->id, true, true);
        } else {
            $availableCountries = Country::getCountries($this->context->language->id, true);
        }

        $this->form = new CustomerAddressForm(
            $this->context->smarty,
            $this->context->language,
            $this->getTranslator(),
            $this->makeAddressPersister(),
            new CustomerAddressFormatter(
                $this->context->country,
                $this->getTranslator(),
                $availableCountries
            )
        );

        $this->form->setAction($this->getCurrentURL());

        return $this->form;
    }

    protected function makeCustomerForm()
    {
        $this->form = new CustomerForm(
            $this->context->smarty,
            $this->context,
            $this->getTranslator(),
            $this->makeCustomerFormatter(),
            new CustomerPersister(
                $this->context,
                $this->get('hashing'),
                $this->getTranslator(),
                $this->guestAllowed
            ),
            $this->getTemplateVarUrls()
        );

        $this->form->setGuestAllowed($this->guestAllowed);

        $this->form->setAction($this->getCurrentURL());

        return $this->form;
    }

    public static function ppaFatalErrorHandler()
    {
        $error = error_get_last();
        
        if ($error !== null) {
            self::ppaErrorHandler($error['type'], $error['message'], $error['file'], $error['line']);
        }
    }

    public static function ppaErrorHandler($errno, $errstr, $errfile, $errline)
    {
        if (!($errno & error_reporting())) {
            return true;
        }

        include_once(_PS_MODULE_DIR_."dmu2panalytics/classes/PpaEndPoint.php");

        $type = "";
        switch ($errno) {
            case E_USER_ERROR:
            case E_ERROR:
                $type = 'Fatal';

                self::$php_errors[] = array(
                    'type'    => $type,
                    'errline' => (int)$errline,
                    'errfile' => str_replace('\\', '\\\\', $errfile), // Hack for Windows paths
                    'errno'   => (int)$errno,
                    'errstr'  => $errstr
                );

                // Il faut tout envoyer en synchrone, car le script s'arrête
                $ppa = new PpaEndPoint();
                if (self::$session_created == false) {
                    if (!preg_match("`\.map$`iUs", $_SERVER['REQUEST_URI']) &&
                        !preg_match("`favicon`iUs", $_SERVER['REQUEST_URI'])) {
                        $ppa->createSession(0, '', '', 0, 0, 0, 0, true);
                        $ppa->addPhpError(self::$php_errors, true);
                    }
                } else {
                    $ppa->addPhpError(self::$php_errors);
                }

                break;
            case E_USER_WARNING:
            case E_WARNING:
                $type = 'Warning';
                break;
        }

        if (!empty($type)) {
            self::$php_errors[] = array(
                'type'    => $type,
                'errline' => (int)$errline,
                'errfile' => str_replace('\\', '\\\\', $errfile), // Hack for Windows paths
                'errno'   => (int)$errno,
                'errstr'  => $errstr
            );
            Context::getContext()->smarty->assign('php_errors', self::$php_errors);
        }

        return true;
    }
}
