<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a commercial license from SARL DREAM ME UP
 * Use, copy, modification or distribution of this source file without written
 * license agreement from the SARL DREAM ME UP is strictly forbidden.
 *
 *   .--.
 *   |   |.--..-. .--, .--.--.   .--.--. .-.   .  . .,-.
 *   |   ;|  (.-'(   | |  |  |   |  |  |(.-'   |  | |   )
 *   '--' '   `--'`-'`-'  '  `-  '  '  `-`--'  `--`-|`-'
 *        w w w . d r e a m - m e - u p . f r       '
 *
 * @author    Dream me up <prestashop@dream-me-up.fr>
 * @copyright 2007 - 2017 Dream me up
 * @license   All Rights Reserved
 */

class PpaEndPoint
{
    protected $id_site;
    protected $id_client;
    protected $id_session;
    protected $call_time;
    protected $context;
    public static $times_functions = array();

    protected $mode_debug = false;
    protected $ip_debug = "";

    public function __construct($client_2p = 0)
    {
        $this->context = Context::getContext();
        $this->id_site = Configuration::get('dmu2pa_id_site');

        if ($this->validIdSite()) {
            $this->call_time = time();

            if (empty($client_2p)) {
                if (!isset($this->context->cookie->dmu2pa_id)) {
                    $this->id_client = uniqid(true);
                    $this->context->cookie->dmu2pa_id = $this->id_client;
                } else {
                    $this->id_client = $this->context->cookie->dmu2pa_id;
                }
            } else {
                $this->id_client = $client_2p;
            }
        }

        if (isset($this->context->cookie->dmu2pa_id_session) && !empty($this->context->cookie->dmu2pa_id_session)) {
            $this->id_session = $this->context->cookie->dmu2pa_id_session;
        }

        if (Tools::getIsset('set_mode_debug') && Tools::getValue('set_mode_debug') == "enable_debug")
        {
            $this->mode_debug = true;
        }

        $this->debugDisplay("isActivated", $this->isActivated());
    }

    public function validIdSite($id_site = false)
    {
        if ($id_site === false) {
            $id_site = $this->id_site;
        }
        if (preg_match("`^PA\-[0-9A-Z]{7}$`iUs", $id_site)) {
            return true;
        }
        return false;
    }
    
    public function startTimer($function_name, $is_customize = true)
    {
        if (!isset(self::$times_functions[$function_name])) {
            self::$times_functions[$function_name] = array('start' => microtime(true),
                'time' => 0, 'is_customize' => $is_customize);
        } else {
            self::$times_functions[$function_name]['start'] = microtime(true);
        }
    }
    
    public function endTimer($function_name)
    {
        self::$times_functions[$function_name]['end'] = microtime(true);

        $tf = self::$times_functions[$function_name];
        $total = $tf['time'] + round((float)(($tf['end']-$tf['start'])*1000));

        self::$times_functions[$function_name]['time'] = $total;

        unset(self::$times_functions[$function_name]['end']);
        unset(self::$times_functions[$function_name]['start']);
    }

    public function testIdSiteLicence($id_site)
    {
        $postdata = http_build_query(
            array(
                'id_site'   => $id_site,
                'call_type' => 'test_licence',
                'iso_lang'  => $this->context->language->iso_code,
            )
        );

        return $this->call($postdata, true);
    }

    public function createSession(
        $exec_time,
        $page_name,
        $meta_title,
        $total_time_queries,
        $total_nb_queries,
        $id_category,
        $id_product,
        $send_now = false
    ) {
        $this->id_session = uniqid($this->generateRandomString(6), true);
        $this->context->cookie->dmu2pa_id_session = $this->id_session;

        $datas = array(
            'id_site'   => $this->id_site,
            'id_client' => $this->id_client,
            'id_session'=> $this->id_session,
            'call_type' => 'session',
            'call_time' => $this->call_time,
            'request_uri' => $_SERVER['REQUEST_URI'],
            'user_agent' => $_SERVER['HTTP_USER_AGENT'],
            'meta_title' => $meta_title,
            'exec_time' => $exec_time,
            'page_type' => $page_name,
            'sql_time' => $total_time_queries,
            'nb_sql_queries' => $total_nb_queries,
            'detail_times' => self::$times_functions,
            'id_cart' => $this->context->cookie->id_cart,
            'id_category' => $id_category,
            'id_product' => $id_product,
            'host'      => $_SERVER['HTTP_HOST']
        );

        if (isset($this->context->cookie->id_cart) && !empty($this->context->cookie->id_cart)) {
            $datas['cart_total'] = $this->context->cart->getOrderTotal();
            $datas['cart_nb_products'] = $this->context->cart->nbProducts();

            $array_send = array();
            $products = $this->context->cart->getProducts();
            if (!empty($products)) {
                foreach ($products as $p) {
                    $array_send[] = array(  'id_product_attribute' => $p['id_product_attribute'],
                                            'id_product' => $p['id_product'],
                                            'cart_quantity' => $p['cart_quantity'],
                                            'name' => $p['name'],
                                            'total_wt' => $p['total_wt'],
                                            'attributes_small' => $p['attributes_small']);
                }
            }
            $datas['cart_products'] = $array_send;
        }

        if (isset($this->context->customer->id) && !empty($this->context->customer->id)) {
            $datas['id_customer'] = $this->context->cookie->id_customer;
            $datas['customer_name'] = Tools::ucfirst(Tools::strtolower($this->context->customer->firstname))." ".
                Tools::strtoupper($this->context->customer->lastname);
        }

        $postdata = http_build_query($datas);

        if ($send_now == true) {
            $this->call($postdata);
        } else {
            $this->cacheCall($postdata);
        }
        
        return $this->id_session;
    }
    

    public function updateSession($ttfb, $page_load)
    {
        $postdata = http_build_query(
            array(
                'id_session'=> $this->id_session,
                'id_site'   => $this->id_site,
                'call_type' => 'session_update',
                'ttfb' => $ttfb,
                'page_load' => $page_load,
            )
        );

        $this->cacheCall($postdata);
    }

    public function addSql($query)
    {
        $postdata = http_build_query(
            array(
                'id_site'   => $this->id_site,
                'id_session' => $this->id_session,
                'call_type' => 'sql',
                'sql_query' => $query['query'],
                'time_query' => $query['time'],
                'stacktrace' => $query['stack'],
                'date_query' => $query['date_query'],
            )
        );

        $this->cacheCall($postdata);
    }

    public function setHookModuleTime($hook_module_time)
    {
        $postdata = http_build_query(
            array(
                'id_site'   => $this->id_site,
                'id_session' => $this->id_session,
                'call_type' => 'hook_module_time',
                'hook_module_time' => $hook_module_time
            )
        );

        $this->cacheCall($postdata);
    }

    public function addErrorPrestashop($errors)
    {
        $postdata = http_build_query(
            array(
                'id_site'   => $this->id_site,
                'id_session' => $this->id_session,
                'call_type' => 'add_error_prestashop',
                'errors' => $errors,
                'post_content' => $_POST
            )
        );

        $this->cacheCall($postdata);
    }

    public function addJsError($errorMsg, $url, $lineNumber)
    {
        $postdata = http_build_query(
            array(
                'id_site'   => $this->id_site,
                'id_session'=> $this->id_session,
                'call_type' => 'add_js_error',
                'errorMsg' => $errorMsg,
                'url' => $url,
                'lineNumber' => $lineNumber,
            )
        );

        $this->cacheCall($postdata);
    }

    public function addPhpError($array_errors, $send_now = false)
    {
        $postdata = http_build_query(
            array(
                'id_site'   => $this->id_site,
                'id_session'=> $this->id_session,
                'call_type' => 'add_php_error',
                'errors' => $array_errors
            )
        );

        if ($send_now == true) {
            $this->call($postdata);
        } else {
            $this->cacheCall($postdata);
        }
    }

    public function addOrder($id_order, $id_cart, $total_order, $nb_products)
    {
        $postdata = http_build_query(
            array(
                'id_site'   => $this->id_site,
                'id_session'=> $this->id_session,
                'call_type' => 'add_order',
                'id_order' => $id_order,
                'id_cart' => $id_cart,
                'total_order' => $total_order,
                'nb_products' => $nb_products,
                'date_order' => date("Y-m-d H:i:s"),
            )
        );

        $this->call($postdata);
    }

    // Version file_get_contents
    protected function call($postdata, $force = false)
    {
        $this->debugDisplay("call", $postdata);

        if ($this->isActivated() || $force == true) {
            $data_host = http_build_query(array('host'    => $_SERVER['HTTP_HOST']));

            $opts = array('http' =>
                array(
                    'method'  => 'POST',
                    'header'  => 'Content-type: application/x-www-form-urlencoded',
                    'content' => $postdata."&".$data_host,
                    'timeout' => 2
                )
            );

            $context  = stream_context_create($opts);
            
            // Insertion et récupération id_session
            $retour = @Tools::file_get_contents("https://www.2p-analytics.com/module-endpoint", false, $context);

            if (!empty($retour)) {
                $retour_json = json_decode($retour);
                if (isset($retour_json->need_cookie_key) && (int)$retour_json->need_cookie_key == 1) {
                    $postdata = http_build_query(
                        array(
                            'id_site'       => $this->id_site,
                            'call_type'     => 'cookie_key',
                            'cookie_key'    => _COOKIE_KEY_,
                        )
                    );

                    $this->call($postdata);
                }
            }

            return $retour;
        }
    }

    // On met l'appel en cache pour qu'il soit envoyé en ajax
    protected function cacheCall($postdata)
    {
        $this->debugDisplay("cacheCall", $postdata);

        if ($this->isActivated()) {
            $sql = "INSERT INTO "._DB_PREFIX_."2pa_cache_call (id_client, postdata, time_call)
                    VALUES ('".pSQL($this->id_client)."', '".pSQL(json_encode($postdata))."', ".microtime(true).")";
            Db::GetInstance()->Execute($sql);
        }
    }

    public function sendWaitingCalls()
    {
        if ($this->isActivated()) {
            $sql = "SELECT * FROM "._DB_PREFIX_."2pa_cache_call 
                    WHERE id_client = '".pSQL($this->id_client)."' ORDER BY time_call";
            $rows = Db::GetInstance()->ExecuteS($sql);

            // Suppression immédiate pour éviter les doublons
            $sql = "DELETE FROM "._DB_PREFIX_."2pa_cache_call
                    WHERE id_client = '".pSQL($this->id_client)."' ORDER BY time_call";
            Db::GetInstance()->Execute($sql);

            foreach ($rows as $row) {
                $postdata = json_decode($row['postdata']);
                $this->call($postdata);
            }
            
            // On va purger toutes les 30 minutes les appels de plus de 6h
            $last_purge = Configuration::get("2PA_PURGE_CALL");
            if (empty($last_purge) || $last_purge < (time()-1800)) {
                Configuration::updateValue("2PA_PURGE_CALL", time());
                
                $sql = "DELETE FROM "._DB_PREFIX_."2pa_cache_call WHERE time_call < ".pSQL(time()-(3600*6));
                Db::GetInstance()->Execute($sql);
            }
        }
    }
    
    public function generateRandomString($length = 10)
    {
        $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $charactersLength = Tools::strlen($characters);
        $randomString = '';
        for ($i = 0; $i < $length; $i++) {
            $randomString .= $characters[rand(0, $charactersLength - 1)];
        }
        return $randomString;
    }

    public function isActivated()
    {
        $active = Configuration::get('dmu2pa_active');

        if ((int)$active == 1 && Module::isEnabled("dmu2panalytics")) {
            return true;
        }

        return false;
    }

    public function getIdClient()
    {
        return $this->id_client;
    }

    public function debugDisplay($title, $content = "")
    {
        if ($this->mode_debug == true)
        {
            echo $title;
            if (!empty($content)) {
                if (version_compare(_PS_VERSION_, '1.7', '<')) {
                    ppp($content);
                } else {
                    dump($content);
                }
            }
        }
    }
}
