<?php
/**
 * Creative Elements - Elementor based PageBuilder
 *
 * @author    WebshopWorks, Elementor
 * @copyright 2019-2020 WebshopWorks.com & Elementor.com
 * @license   https://www.gnu.org/licenses/gpl-3.0.html
 */

namespace CE;

defined('_PS_VERSION_') or die;

class TemplateLibrarySourceLocal extends TemplateLibrarySourceBase
{
    const CPT = 'elementor_library';

    // const TAXONOMY_TYPE_SLUG = 'elementor_library_type';

    // const TYPE_META_KEY = '_elementor_template_type';

    private static $_template_types = array('page', 'section');

    public static function getTemplateType($template_id)
    {
        // return get_post_meta($template_id, self::TYPE_META_KEY, true);
        return get_post($template_id)->_obj->type;
    }

    /*
    public static function isBaseTemplatesScreen()
    {
        global $current_screen;

        if (!$current_screen) {
            return false;
        }

        return 'edit' === $current_screen->base && self::CPT === $current_screen->post_type;
    }
    */

    public static function addTemplateType($type)
    {
        self::$_template_types[] = $type;
    }

    public function getId()
    {
        return 'local';
    }

    public function getTitle()
    {
        return __('Local', 'elementor');
    }

    /*
    public function registerData()
    {
        $labels = array(
            'name' => _x('My Library', 'Template Library', 'elementor'),
            'singular_name' => _x('Template', 'Template Library', 'elementor'),
            'add_new' => _x('Add New', 'Template Library', 'elementor'),
            'add_new_item' => _x('Add New Template', 'Template Library', 'elementor'),
            'edit_item' => _x('Edit Template', 'Template Library', 'elementor'),
            'new_item' => _x('New Template', 'Template Library', 'elementor'),
            'all_items' => _x('All Templates', 'Template Library', 'elementor'),
            'view_item' => _x('View Template', 'Template Library', 'elementor'),
            'search_items' => _x('Search Template', 'Template Library', 'elementor'),
            'not_found' => _x('No Templates found', 'Template Library', 'elementor'),
            'not_found_in_trash' => _x('No Templates found in Trash', 'Template Library', 'elementor'),
            'parent_item_colon' => '',
            'menu_name' => _x('My Library', 'Template Library', 'elementor'),
        );

        $args = array(
            'labels' => $labels,
            'public' => true,
            'rewrite' => false,
            'show_ui' => true,
            'show_in_menu' => false,
            'show_in_nav_menus' => false,
            'exclude_from_search' => true,
            'capability_type' => 'post',
            'hierarchical' => false,
            'supports' => array('title', 'thumbnail', 'author', 'elementor'),
        );

        register_post_type(
            self::CPT,
            apply_filters('elementor/template_library/sources/local/register_post_type_args', $args)
        );

        $args = array(
            'hierarchical' => false,
            'show_ui' => false,
            'show_in_nav_menus' => false,
            'show_admin_column' => true,
            'query_var' => is_admin(),
            'rewrite' => false,
            'public' => false,
            'label' => _x('Type', 'Template Library', 'elementor'),
        );

        register_taxonomy(
            self::TAXONOMY_TYPE_SLUG,
            self::CPT,
            apply_filters('elementor/template_library/sources/local/register_taxonomy_args', $args)
        );
    }

    public function registerAdminMenu()
    {
        add_submenu_page(
            Settings::PAGE_ID,
            __('My Library', 'elementor'),
            __('My Library', 'elementor'),
            'edit_pages',
            'edit.php?post_type=' . self::CPT
        );
    }
    */

    public function getItems($args = array())
    {
        $table = _DB_PREFIX_ . \CETemplate::$definition['table'];
        $templates = array();

        $db = \Db::getInstance();
        $rows = $db->executeS("SELECT id_ce_template, id_employee, title, type, date_add FROM $table WHERE active = 1 ORDER BY title ASC");

        foreach ($rows as &$row) {
            $post = new \stdClass();
            $post->ID = new UId($row['id_ce_template'], UId::TEMPLATE);
            $post->post_author = $row['id_employee'];
            $post->post_date = $row['date_add'];
            $post->post_title = $row['title'];
            $post->template_type = $row['type'];

            $templates[] = $this->getItem($post);
        }

        if (!empty($args)) {
            $templates = wp_list_filter($templates, $args);
        }

        return $templates;
    }

    public function saveItem($template_data)
    {
        if (!in_array($template_data['type'], self::$_template_types)) {
            return new \PrestaShopException("save_error - Invalid template type `{$template_data['type']}`");
        }

        $post_id = wp_insert_post(array(
            'post_title' => !empty($template_data['title']) ? $template_data['title'] : __('(no title)', 'elementor'),
            'post_status' => 'publish',
            'post_type' => self::CPT,
            'template_type' => $template_data['type'],
        ));

        if (is_wp_error($post_id)) {
            return $post_id;
        }

        Plugin::instance()->db->setEditMode($post_id);

        Plugin::instance()->db->saveEditor($post_id, $template_data['data']);

        // $this->save_item_type($post_id, $template_data['type']);

        do_action('elementor/template-library/after_save_template', $post_id, $template_data);

        do_action('elementor/template-library/after_update_template', $post_id, $template_data);

        return $post_id;
    }

    public function updateItem($new_data)
    {
        Plugin::instance()->db->save_editor($new_data['id'], $new_data['data']);

        return true;
    }

    /**
     * @param int $item_id
     *
     * @return array
     */
    public function getItem($item)
    {
        $post = is_object($item) ? $item : get_post($item);

        $user = get_user_by('id', $post->post_author);

        $data = array(
            'template_id' => "{$post->ID}",
            'source' => $this->getId(),
            'type' => $post->template_type,
            'title' => $post->post_title,
            // 'thumbnail' => get_the_post_thumbnail_url($post),
            'date' => \Tools::displayDate($post->post_date),
            'author' => $user ? $user->display_name : __('Unknown', 'elementor'),
            'categories' => array(),
            'keywords' => array(),
            'export_link' => $this->_getExportLink($post->ID),
            'url' => get_preview_post_link($post->ID),
        );

        return apply_filters('elementor/template-library/get_template', $data);
    }

    public function getContent($item_id, $context = 'display')
    {
        $db = Plugin::instance()->db;

        // TODO: Valid the data (in JS too!)
        if ('display' === $context) {
            $data = $db->getBuilder($item_id);
        } else {
            $data = $db->getPlainEditor($item_id);
        }

        $data = $this->replaceElementsIds($data);

        return $data;
    }

    public function deleteTemplate($item_id)
    {
        wp_delete_post($item_id, true);
    }

    public function exportTemplate($item_id)
    {
        $template_data = $this->getContent($item_id, 'raw');

        $template_data = $this->processExportImportData($template_data, 'onExport');

        if (empty($template_data)) {
            return new \PrestaShopException('404 - The template does not exist');
        }
        $post = get_post($item_id);

        // TODO: More fields to export?
        $export_data = array(
            'version' => _CE_VERSION_,
            'title' => $post->post_title,
            'type' => $post->template_type,
            'data' => $template_data,
        );

        $filename = 'CreativeElements_' . $post->_obj->id . '_' . date('Y-m-d') . '.json';
        $template_contents = json_encode($export_data);
        $filesize = \Tools::strlen($template_contents);

        // Headers to prompt "Save As"
        header('Content-Type: application/octet-stream');
        header('Content-Disposition: attachment; filename=' . $filename);
        header('Expires: 0');
        header('Cache-Control: must-revalidate');
        header('Pragma: public');
        header('Content-Length: ' . $filesize);

        // Clear buffering just in case
        @ob_end_clean();

        flush();

        // Output file contents
        echo $template_contents;

        die;
    }

    public function importTemplate()
    {
        $import_file = $_FILES['file']['tmp_name'];

        if (empty($import_file)) {
            return new \PrestaShopException('file_error - Please upload a file to import');
        }

        $data = 'data';
        $is_invalid_file = true;
        $content = json_decode(\Tools::file_get_contents($import_file), true);

        if (!empty($content[$data])) {
            if (is_string($content[$data])) {
                // iqit compatibility
                $content['type'] = 'page';
                $content[$data] = json_decode($content[$data], true);
            }
            if (is_array($content[$data])) {
                $is_invalid_file = false;
            }
        } elseif (!empty($content['content']) && is_array($content['content'])) {
            $is_invalid_file = false;
            $data = 'content';
        }

        if ($is_invalid_file) {
            return new \PrestaShopException('file_error - Invalid File');
        }

        $content_data = $this->processExportImportData($content[$data], 'onImport');

        $item_id = $this->saveItem(array(
            'data' => $content_data,
            'title' => $content['title'],
            'type' => $content['type'],
        ));

        if ($item_id instanceof \PrestaShopException) {
            return $item_id;
        }

        return $this->getItem($item_id);
    }

    /*
    public function post_row_actions( $actions, \WP_Post $post ) {
        if ( self::is_base_templates_screen() ) {
            if ( $this->is_template_supports_export( $post->ID ) ) {
                $actions['export-template'] = sprintf( '<a href="%s">%s</a>', $this->_get_export_link( $post->ID ), __( 'Export Template', 'elementor' ) );
            }

            unset( $actions['inline hide-if-no-js'] );
        }

        return $actions;
    }

    public function admin_import_template_form() {
        if ( ! self::is_base_templates_screen() ) {
            return;
        }
        ?>
        <div id="elementor-hidden-area">
            <a id="elementor-import-template-trigger" class="page-title-action"><?php _e( 'Import Template', 'elementor' ); ?></a>
            <div id="elementor-import-template-area">
                <div id="elementor-import-template-title"><?php _e( 'Choose an Elementor template JSON file, and add it to the list of templates available in your library.', 'elementor' ); ?></div>
                <form id="elementor-import-template-form" method="post" action="<?php echo admin_url( 'admin-ajax.php' ); ?>" enctype="multipart/form-data">
                    <input type="hidden" name="action" value="elementor_import_template">
                    <fieldset id="elementor-import-template-form-inputs">
                        <input type="file" name="file" accept="application/json" required>
                        <input type="submit" class="button" value="<?php _e( 'Import Now', 'elementor' ); ?>">
                    </fieldset>
                </form>
            </div>
        </div>
        <?php
    }

    public function block_template_frontend() {
        if ( is_singular( self::CPT ) && ! User::is_current_user_can_edit() ) {
            wp_redirect( site_url(), 301 );
            die;
        }
    }

    public function is_template_supports_export( $template_id ) {
        return apply_filters( 'elementor/template_library/is_template_supports_export', true, $template_id );
    }
    */

    private function _getExportLink($item_id)
    {
        return \Context::getContext()->link->getAdminLink('AdminCEEditor') . '&' . http_build_query(array(
            'ajax' => 1,
            'action' => 'export_template',
            'source' => $this->getId(),
            'template_id' => "$item_id",
        ));
    }

    /*
    public function on_save_post( $post_id, $post ) {
        if ( self::CPT !== $post->post_type ) {
            return;
        }

        if ( self::get_template_type( $post_id ) ) { // It's already with a type
            return;
        }

        $this->save_item_type( $post_id, 'page' );
    }

    private function save_item_type( $post_id, $type ) {
        update_post_meta( $post_id, self::TYPE_META_KEY, $type );

        wp_set_object_terms( $post_id, $type, self::TAXONOMY_TYPE_SLUG );
    }

    /**
     * @param $query \WP_Query
     *
    public function admin_query_filter_types( $query ) {
        if ( ! function_exists( 'get_current_screen' ) ) {
            return;
        }

        $library_screen_id = 'edit-' . self::CPT;
        $current_screen = get_current_screen();

        if ( ! isset( $current_screen->id ) || $library_screen_id !== $current_screen->id ) {
            return;
        }

        $query->query_vars['meta_key'] = self::TYPE_META_KEY;
        $query->query_vars['meta_value'] = self::$_template_types;
    }

    private function _add_actions() {
        if ( is_admin() ) {
            add_action( 'admin_menu', [ $this, 'register_admin_menu' ], 50 );
            add_filter( 'post_row_actions', [ $this, 'post_row_actions' ], 10, 2 );
            add_action( 'admin_footer', [ $this, 'admin_import_template_form' ] );
            add_action( 'save_post', [ $this, 'on_save_post' ], 10, 2 );
            add_action( 'parse_query', [ $this, 'admin_query_filter_types' ] );
        }

        add_action( 'template_redirect', [ $this, 'block_template_frontend' ] );
    }

    public function __construct() {
        parent::__construct();

        $this->_add_actions();
    }
    */
}
