<?php
/**
 * Creative Elements - Elementor based PageBuilder
 *
 * @author    WebshopWorks, Elementor
 * @copyright 2019-2020 WebshopWorks.com & Elementor.com
 * @license   https://www.gnu.org/licenses/gpl-3.0.html
 */

namespace CE;

defined('_PS_VERSION_') or die;

class WidgetsManager
{
    /**
     * @var WidgetBase[]
     */
    private $_widget_types = null;

    private function _initWidgets()
    {
        $build_widgets_filename = array(
            'common',
            'heading',
            'image',
            'text-editor',
            'video',
            'button',
            'divider',
            'spacer',
            'google-maps',
            'icon',
            'image-box',
            'icon-box',
            // 'image-gallery',
            'flip-box',
            'call-to-action',
            'image-carousel',
            'image-hotspot',
            'layer-slider',
            'icon-list',
            'counter',
            'countdown',
            'progress',
            'testimonial',
            'testimonial-carousel',
            'tabs',
            'accordion',
            'toggle',
            'social-icons',
            'facebook-page',
            'facebook-button',
            'alert',
            // 'audio',
            'shortcode',
            'html',
            'menu-anchor',
            // PS
            'product-box',
            'product-grid',
            'product-carousel',
            'trustedshops-reviews',
            'ajax-search',
            // 'login',
            'contact-form',
            'email-subscription',
        );

        // skip following widgets on PS 1.6.x
        if (!_CE_PS16_) {
            $build_widgets_filename[] = 'image-slider';
            $build_widgets_filename[] = 'category-tree';
        } elseif (file_exists(_PS_MODULE_DIR_ . 'blockcategories/blockcategories.tpl')) {
            $build_widgets_filename[] = 'category-tree';
        }
        $build_widgets_filename[] = 'module';

        $this->_widget_types = array();

        foreach ($build_widgets_filename as $widget_filename) {
            include _CE_PATH_ . 'includes/widgets/' . $widget_filename . '.php';

            $class_name = __NAMESPACE__ . '\Widget' . str_replace('-', '', $widget_filename);

            $this->registerWidgetType(new $class_name());
        }

        do_action('elementor/widgets/widgets_registered', $this);
    }

    private function _requireFiles()
    {
        require_once _CE_PATH_ . 'includes/base/element-base.php';
        require _CE_PATH_ . 'includes/base/widget-base.php';
        require _CE_PATH_ . 'includes/base/widget-product-base.php';
        // require _CE_PATH_ . 'includes/widgets/multi-section-base.php';
    }

    public function registerWidgetType(WidgetBase $widget)
    {
        if (is_null($this->_widget_types)) {
            $this->_initWidgets();
        }

        $this->_widget_types[$widget->getName()] = $widget;

        return true;
    }

    public function unregisterWidgetType($name)
    {
        if (!isset($this->_widget_types[$name])) {
            return false;
        }

        unset($this->_widget_types[$name]);

        return true;
    }

    public function getWidgetTypes($widget_name = null)
    {
        if (is_null($this->_widget_types)) {
            $this->_initWidgets();
        }

        if (null !== $widget_name) {
            return isset($this->_widget_types[$widget_name]) ? $this->_widget_types[$widget_name] : null;
        }

        return $this->_widget_types;
    }

    public function getWidgetTypesConfig()
    {
        $config = array();

        foreach ($this->getWidgetTypes() as $widget_key => $widget) {
            if (!$widget->showInPanel()) {
                continue;
            }

            $config[$widget_key] = $widget->getConfig();
        }

        return $config;
    }

    public function ajaxRenderWidget()
    {
        $data = empty(${'_POST'}['data']) ? '' : ${'_POST'}['data'];
        $data = json_decode($data, true);
        $render_html = 'Missing widget: ' . $data['widgetType'];

        // Start buffering
        ob_start();

        $widget = Plugin::instance()->elements_manager->createElementInstance($data);

        $widget->renderContent();

        $render_html = ob_get_clean();

        wp_send_json_success(array(
            'render' => $render_html,
        ));
    }

    public function renderWidgetsContent()
    {
        foreach ($this->getWidgetTypes() as $widget) {
            $widget->printTemplate();
        }
    }

    public function __construct()
    {
        $this->_requireFiles();
    }
}
