<?php
/**
 * Creative Elements - Elementor based PageBuilder
 *
 * @author    WebshopWorks
 * @copyright 2019-2020 WebshopWorks.com
 * @license   One domain support license
 */

defined('_PS_VERSION_') or die;

require_once _PS_MODULE_DIR_ . 'creativeelements/includes/plugin.php';

class CreativeElementsPreviewModuleFrontController extends ModuleFrontController
{
    protected $uid;

    protected $title;

    public function init()
    {
        if (Tools::getIsset('redirect') && CreativeElements::hasAdminToken('AdminCEEditor')) {
            $cookie = CE\get_post_meta(0, 'cookie', true);
            CE\delete_post_meta(0, 'cookie');

            if (!empty($cookie)) {
                $lifetime = max(1, (int) Configuration::get('PS_COOKIE_LIFETIME_BO')) * 3600 + time();
                $admin = new Cookie('psAdmin', '', $lifetime);
                foreach ($cookie as $key => &$value) {
                    $admin->{$key} = $value;
                }
                $admin->id_employee = Tools::getValue('id_employee');
                $admin->write();
            }
            Tools::redirectAdmin(urldecode(Tools::getValue('redirect')));
        }

        $this->uid = CreativeElements::isPreviewMode();

        if (!$this->uid) {
            Tools::redirect('index.php?controller=404');
        }

        parent::init();
    }

    public function initContent()
    {
        $model = $this->uid->getModel();

        if ('CETemplate' != $model) {
            $this->warning[] = sprintf(
                '%s <a href="%s" class="ce-read-more">%s</a>',
                CE\__('Undefined Position!'),
                CE\esc_attr(CE\__('http://docs.webshopworks.com/creative-elements/79-troubleshooting/337-undefined-position')),
                CE\__('Learn More')
            );
        }
        $post = CE\get_post($this->uid);

        $this->title = $post->post_title;
        $this->context->smarty->assign($model::${'definition'}['table'], array(
            'id' => $post->_obj->id,
            'content' => '',
        ));

        parent::initContent();

        $this->title = $post->post_title;
        $this->context->smarty->addTemplateDir(_CE_TEMPLATES_);
        $this->context->smarty->assign(array(
            'HOOK_LEFT_COLUMN' => '',
            'HOOK_RIGHT_COLUMN' => '',
        ));

        if (_CE_PS16_) {
            $this->context->smarty->assign('path', $this->getBreadcrumbPath());
            $this->template = 'front/preview-1.6.tpl';
        } else {
            $this->context->smarty->assign('breadcrumb', $this->getBreadcrumb());
            $this->template = 'front/preview.tpl';
        }
    }

    public function getBreadcrumbLinks()
    {
        $breadcrumb = array(
            'links' => array(
                array(
                    'title' => 'Creative Elements',
                    'url' => 'javascript:;',
                ),
                array(
                    'title' => CE\__('Preview', 'elementor'),
                    'url' => 'javascript:;',
                ),
            ),
        );
        if (!empty($this->title)) {
            $breadcrumb['links'][] = array(
                'title' => $this->title,
                'url' => 'javascript:;',
            );
        }
        return $breadcrumb;
    }

    public function getBreadcrumbPath()
    {
        $breadcrumb = $this->getBreadcrumbLinks();
        $links = array_reverse($breadcrumb['links']);
        $path = array();

        foreach ($links as $i => $link) {
            array_unshift($path, $i ? "<a>{$link['title']}</a>" : $link['title']);
        }
        return implode('<span class="navigation-pipe">&gt;</span>', $path);
    }
}

function cefilter(&$str)
{
    echo $str;
}
