<?php
/**
 * Creative Elements - Elementor based PageBuilder
 *
 * @author    WebshopWorks
 * @copyright 2019-2020 WebshopWorks.com
 * @license   One domain support license
 */

defined('_PS_VERSION_') or die;

class AdminCESettingsController extends ModuleAdminController
{
    public function __construct()
    {
        $this->bootstrap = true;
        $this->className = 'CESettings';
        $this->table = 'configuration';
        $this->fields_options = array();

        parent::__construct();

        $this->fields_options['genear_settings'] = array(
            'icon' => 'icon-cog',
            'title' => $this->l('General Settings'),
            'fields' => array(
                'elementor_frontend_edit' => array(
                    'title' => $this->l('Show Edit Icon on Frontend'),
                    'desc' => $this->l('Displays an edit icon on frontend while employee has active session. By clicking on this icon the live editor will open.'),
                    'validation' => 'isBool',
                    'cast' => 'intval',
                    'type' => 'bool',
                    'default' => '1',
                ),
            ),
            'submit' => array(
                'title' => $this->l('Save')
            ),
        );

        $this->fields_options['style_settings'] = array(
            'icon' => 'icon-adjust',
            'title' => $this->l('Style Settings'),
            'fields' => array(
                'elementor_disable_color_schemes' => array(
                    'title' => $this->l('Disable Color Palettes'),
                    'desc' => $this->l('Color Palettes let you change the default colors that appear under the various widgets. If you prefer to inherit the colors from your theme, you can disable this feature.'),
                    'validation' => 'isBool',
                    'cast' => 'intval',
                    'type' => 'bool',
                    'default' => '0',
                ),
                'elementor_disable_typography_schemes' => array(
                    'title' => $this->l('Disable Default Fonts'),
                    'desc' => $this->l('Default Fonts let you change the fonts that appear on Elementor from one place. If you prefer to inherit the fonts from your theme, you can disable this feature here.'),
                    'validation' => 'isBool',
                    'cast' => 'intval',
                    'type' => 'bool',
                    'default' => '0',
                ),
                'elementor_default_generic_fonts' => array(
                    'title' => $this->l('Default Generic Fonts'),
                    'desc' => $this->l('The list of fonts used if the chosen font is not available.'),
                    'cast' => 'strval',
                    'type' => 'text',
                    'class' => 'fixed-width-lg',
                ),
                'elementor_container_width' => array(
                    'title' => $this->l('Content Max Width'),
                    'desc' => $this->l('Sets the default width of the content area (Default: 1140)'),
                    'suffix' => 'px',
                    'validation' => 'isUnsignedInt',
                    'cast' => 'intval',
                    'type' => 'text',
                    'class' => 'fixed-width-lg',
                ),
                'elementor_stretched_section_container' => array(
                    'title' => $this->l('Stretched Section Fit To'),
                    'desc' => $this->l('Enter parent element selector to which stretched sections will fit to (e.g. #primary / .wrapper / main etc). Leave blank to fit to page width.'),
                    'cast' => 'strval',
                    'type' => 'text',
                    'class' => 'fixed-width-lg',
                ),
            ),
            'submit' => array(
                'title' => $this->l('Save')
            ),
        );
        $this->fields_options['advanced_settings'] = array(
            'class' => 'ce-adv-settings',
            'icon' => 'icon-cogs',
            'title' => $this->l('Advanced Settings'),
            'info' => sprintf(
                '<div class="alert alert-warning">%s</div>',
                $this->l('Do not change these options without experience, incorrect settings might break your site.')
            ),
            'fields' => array(
                'elementor_load_fontawesome' => array(
                    'title' => $this->l('Load FontAwesome Library'),
                    'desc' => $this->l('Font Awesome gives you scalable vector icons that can instantly be customized - size, color, drop shadow, and anything that can be done with the power of CSS.'),
                    'validation' => 'isBool',
                    'cast' => 'intval',
                    'type' => 'bool',
                    'default' => '1',
                ),
                'elementor_load_waypoints' => array(
                    'title' => $this->l('Load Waypoints Library'),
                    'desc' => $this->l('Waypoints library is the easiest way to trigger a function when you scroll to an element.'),
                    'validation' => 'isBool',
                    'cast' => 'intval',
                    'type' => 'bool',
                    'default' => '1',
                ),
                'elementor_load_slick' => array(
                    'title' => $this->l('Load Slick Library'),
                    'desc' => $this->l('Slick is a jQuery plugin for creating fully customizable, responsive and mobile friendly carousels/sliders that work with any html elements.'),
                    'validation' => 'isBool',
                    'cast' => 'intval',
                    'type' => 'bool',
                    'default' => '1',
                ),
            ),
            'submit' => array(
                'title' => $this->l('Save')
            ),
        );
    }

    public function setMedia($isNewTheme = false)
    {
        parent::setMedia($isNewTheme);

        $this->css_files[_MODULE_DIR_ . 'creativeelements/views/css/admin.css?v=' . _CE_VERSION_] = 'all';
    }

    protected function l($string, $module = 'creativeelements', $addslashes = false, $htmlentities = true)
    {
        $str = Translate::getModuleTranslation($module, $string, '', null, $addslashes || !$htmlentities);

        return $htmlentities ? $str : call_user_func('strip' . 'slashes', $str);
    }
}
