<?php
/**
 * Creative Elements - Elementor based PageBuilder
 *
 * @author    WebshopWorks
 * @copyright 2019-2020 WebshopWorks.com
 * @license   One domain support license
 */

defined('_PS_VERSION_') or die;

class AdminCEEditorController extends ModuleAdminController
{
    public $name = 'AdminCEEditor';

    public $display_header = false;

    public $content_only = true;

    /** @var CE\UId */
    protected $uid;

    public function init()
    {
        Tools::getIsset('uid') && $this->uid = CE\UId::parse(Tools::getValue('uid'));

        $this->initProcess();
    }

    public function initCursedPage()
    {
        if ($this->ajax) {
            CE\wp_send_json_error('token_expired');
        }
        parent::initCursedPage();
    }

    public function initProcess()
    {
        header('Cache-Control: no-store, no-cache');

        $this->ajax = Tools::getIsset('ajax');
        $this->action = Tools::getValue('action', '');
        $this->tabAccess = Profile::getProfileAccess($this->context->employee->id_profile, $this->id);

        $this->viewAccess() or Tools::redirectAdmin($_SERVER['HTTP_REFERER']);

        if (Shop::isFeatureActive() && $this->uid && !$this->ajax) {
            $domain = array(
                'http://' => 'domain',
                'https://' => 'domain_ssl',
            );
            $protocol = Tools::getShopProtocol();

            if ($this->uid->id_shop && $this->uid->id_shop != $this->context->shop->id ||
                $_SERVER['HTTP_HOST'] != $this->context->shop->{$domain[$protocol]}
            ) {
                CE\update_post_meta(0, 'cookie', $this->context->cookie->getAll());

                Tools::redirectAdmin(
                    $this->context->link->getModuleLink('creativeelements', 'preview', array(
                        'id_employee' => $this->context->employee->id,
                        'adtoken' => Tools::getAdminTokenLite('AdminCEEditor'),
                        'redirect' => urlencode($_SERVER['REQUEST_URI']),
                    ), true, null, $this->uid->id_shop)
                );
            }
        }
        require_once _PS_MODULE_DIR_ . 'creativeelements/includes/plugin.php';

        CE\Plugin::instance() && CE\do_action('init');
    }

    public function postProcess()
    {
        $process = 'process' . Tools::toCamelCase($this->action, true);

        if ($this->ajax) {
            method_exists($this, "ajax$process") && $this->{"ajax$process"}();

            CE\do_action('wp_ajax_elementor_' . $this->action);
        } elseif ($this->action && method_exists($this, $process)) {
            // Call process
            return $this->$process();
        }

        return false;
    }

    public function initContent()
    {
        if (!$this->uid) {
            Tools::redirectAdmin($_SERVER['HTTP_REFERER']);
        }

        // Enqueue CE assets
        CE\wp_enqueue_style('ce-editor', _CE_ASSETS_URL_ . 'css/editor-ce.css', array(), _CE_VERSION_);
        CE\wp_register_script('ce-editor', _CE_ASSETS_URL_ . 'js/editor-ce.js', array(), _CE_VERSION_, true);
        CE\wp_localize_script('ce-editor', 'ce', array(
            'PS16' => _CE_PS16_,
            'wrapfix' => CE\Helper::getWrapfix(),
        ));
        CE\wp_localize_script('ce-editor', 'baseDir', __PS_BASE_URI__);
        CE\wp_enqueue_script('ce-editor');

        CE\Plugin::instance()->editor->init();
    }

    public function processBackToPsEditor()
    {
        if (CE\current_user_can('edit', $this->uid)) {
            CE\Plugin::instance()->db->setEditMode($this->uid, 'editor');
        }
        Tools::redirectAdmin($_SERVER['HTTP_REFERER']);
    }

    public function processAddFooterProduct()
    {
        if (!$this->uid->id || $this->uid->id_type != CE\UId::PRODUCT) {
            Tools::redirectAdmin($_SERVER['HTTP_REFERER']);
        }

        $content = new CEContent();
        $content->hook = 'displayFooterProduct';
        $content->id_product = $this->uid->id;
        $content->active = true;
        $content->content = array();
        $content->title = array();

        foreach (Language::getLanguages(false) as $lang) {
            $content->title[$lang['id_lang']] = 'Product Footer #' . $this->uid->id;
        }
        $content->save();

        $uid = new CE\UId($content->id, CE\UId::CONTENT, $this->uid->id_lang, $this->uid->id_shop);

        Tools::redirectAdmin(
            $this->context->link->getAdminLink('AdminCEEditor') . "&uid=$uid&footerProduct={$content->id_product}"
        );
    }

    public function ajaxProcessSaveBuilder()
    {
        // Set edit mode to builder only at save
        CE\Plugin::instance()->db->setEditMode(Tools::getValue('post_id'));
    }

    public function ajaxProcessGetLanguageContent()
    {
        if ($data = CE\get_post_meta($this->uid, '_elementor_data', true)) {
            CE\Plugin::instance()->db->iterateData($data, function ($element) {
                $element['id'] = CE\Utils::generateRandomString();

                return $element;
            });
        }
        return is_array($data)
            ? CE\wp_send_json_success($data)
            : CE\wp_send_json_error()
        ;
    }
}
